/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.common;

import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.project.property.ProjectPropertyService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.inject.Inject;
import net.savignano.snotify.atlassian.common.properties.ASnotifyProjectProperties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JiraComponent
public class SnotifyProjectProperties
extends ASnotifyProjectProperties {
    private static final Logger log = LoggerFactory.getLogger(SnotifyProjectProperties.class);
    @Inject
    @ComponentImport
    private ProjectPropertyService props;
    @Inject
    @ComponentImport
    private JiraAuthenticationContext authContext;

    @Override
    protected String getString(String key, String projectName) {
        ApplicationUser user = this.getUser(projectName);
        log.trace("Getting project property \"{}\" for project {} with user {}.", new Object[]{key, projectName, user});
        EntityPropertyService.PropertyResult result = this.getProps().getProperty(user, projectName, key);
        this.logResult((ServiceResultImpl)result);
        if (result.isValid()) {
            EntityProperty prop = (EntityProperty)result.getEntityProperty().getOrNull();
            if (prop == null) {
                log.trace("Project property \"{}\" for project {} does not exist.", (Object)key, (Object)projectName);
                return null;
            }
            String value = prop.getValue();
            if (StringUtils.isBlank((CharSequence)value)) {
                log.trace("Project property \"{}\" for project {} is considered null.", (Object)key, (Object)projectName);
                return null;
            }
            log.trace("Project property \"{}\"for project {} is: {}", new Object[]{key, projectName, value});
            return value;
        }
        log.error("Could not access project property \"{}\" for project {}.", (Object)key, (Object)projectName);
        return null;
    }

    @Override
    protected void setString(String key, String value, String projectName) {
        ApplicationUser user = this.getUser(projectName);
        log.trace("Setting project property \"{}\" for project {} with user {} to: {}", new Object[]{key, projectName, user, value});
        ProjectPropertyService props = this.getProps();
        if (value == null) {
            EntityPropertyService.DeletePropertyValidationResult result = props.validateDeleteProperty(user, projectName, key);
            this.logResult((ServiceResultImpl)result);
            if (result.isValid()) {
                props.deleteProperty(user, result);
                log.trace("Project property \"{}\" successfully deleted.", (Object)key);
            } else {
                log.error("Project property \"{}\" for project {} could not be deleted.", (Object)key, (Object)projectName);
            }
        } else {
            EntityPropertyService.SetPropertyValidationResult result = props.validateSetProperty(user, projectName, new EntityPropertyService.PropertyInput(value, key));
            this.logResult((ServiceResultImpl)result);
            if (result.isValid()) {
                props.setProperty(user, result);
                log.trace("Project property \"{}\" successfully set.", (Object)key);
            } else {
                log.error("Project property \"{}\" for project {} could not be set.", (Object)key, (Object)projectName);
            }
        }
    }

    private void logResult(ServiceResultImpl result) {
        if (result.getErrorCollection().hasAnyErrors() && log.isErrorEnabled()) {
            for (String error : result.getErrorCollection().getErrorMessages()) {
                log.error(error);
            }
            if (result.getErrorCollection().getReasons().contains(ErrorCollection.Reason.FORBIDDEN)) {
                log.error("There is a problem with the project lead user: You cannot edit the configuration of this project.");
            }
        }
        if (result.getWarningCollection().hasAnyWarnings() && log.isWarnEnabled()) {
            for (String warning : result.getWarningCollection().getWarnings()) {
                log.warn(warning);
            }
        }
    }

    private ProjectPropertyService getProps() {
        if (this.props == null) {
            log.trace("Injection of ProjectPropertyService failed. Loading manually.");
            this.props = (ProjectPropertyService)ComponentAccessor.getComponent(ProjectPropertyService.class);
        }
        return this.props;
    }

    private ApplicationUser getUser(String projectKey) {
        ApplicationUser user = this.getLoggedInUser();
        if (user == null) {
            user = this.getProjectLead(projectKey);
        }
        return user;
    }

    private ApplicationUser getLoggedInUser() {
        if (this.authContext == null) {
            log.trace("Injection of JiraAuthenticationContext failed. Loading manually.");
            this.authContext = ComponentAccessor.getJiraAuthenticationContext();
        }
        return this.authContext == null ? null : this.authContext.getLoggedInUser();
    }

    private ApplicationUser getProjectLead(String projectKey) {
        log.trace("Retrieving project lead for project {}.", (Object)projectKey);
        ProjectManager manager = ComponentAccessor.getProjectManager();
        Project project = manager.getProjectByCurrentKey(projectKey);
        if (project == null) {
            log.error("Project {} does not exist.", (Object)projectKey);
            return null;
        }
        ApplicationUser lead = project.getProjectLead();
        if (lead == null) {
            log.error("Lead for project {} does not exist.", (Object)projectKey);
        }
        log.trace("Found project lead: {}", (Object)lead);
        return lead;
    }
}

