/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.gui.rest.profile;

import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.IOUtil;
import com.atlassian.plugins.rest.api.multipart.FilePart;
import com.atlassian.plugins.rest.api.multipart.MultipartFormParam;
import com.atlassian.plugins.rest.api.security.annotation.UnlicensedSiteAccess;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.user.IUser;
import net.savignano.snotify.jira.common.JiraUser;
import net.savignano.snotify.jira.gui.rest.profile.PublicUserEditing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;

@Path(value="uploadPgpKey")
public class PublicPgpKeyUpload
extends PublicUserEditing {
    @PUT
    @UnlicensedSiteAccess
    @Consumes(value={"multipart/form-data"})
    public Response upload(@MultipartFormParam(value="pgp_key") FilePart pgpKeyPart, @QueryParam(value="atl_token") String token, @Context HttpServletRequest req) {
        JiraUser user = null;
        try {
            if (!this.getAuthContext().isLoggedInUser()) {
                this.getLog().info("PGP key upload not authorized.");
                return this.createResponse(Response.Status.UNAUTHORIZED);
            }
            user = new JiraUser(this.getAuthContext().getLoggedInUser());
            if (!this.hasMatchinXsrfToken(token, req.getSession(false))) {
                this.getLog().warn("XSRF token violation detected when uploading a PGP key for customer: {}", (Object)user);
                String msg = this.getI18n().getText("jsd-portal-email-security.error.xsrf.message");
                return this.createResponse(Response.Status.FORBIDDEN, msg);
            }
            if (!this.isUploadAllowed(ECryptographyType.PGP)) {
                this.getLog().info("Uploading of PGP key is not allowed for user: {}", (Object)user);
                String msg = this.getI18n().getText("jsd-portal-email-security.error.pgp.upload.message.adminForbidden");
                return this.createResponse(Response.Status.FORBIDDEN, msg);
            }
            if (pgpKeyPart == null || pgpKeyPart.getSize() == 0L) {
                String msg = this.getI18n().getText("jsd-portal-email-security.error.pgp.upload.message.noFile");
                return this.createResponse(Response.Status.BAD_REQUEST, msg);
            }
            return this.setPgpKey(pgpKeyPart, user);
        }
        catch (Exception e) {
            this.getLog().error("Error while uploading PGP key for user " + user + ". Error message: " + e.getMessage(), (Throwable)e);
            String msg = this.getI18n().getText("jsd-portal-email-security.error.pgp.upload.message.generalException");
            return this.createResponse(Response.Status.INTERNAL_SERVER_ERROR, msg);
        }
    }

    private Response setPgpKey(FilePart pgpPart, IUser<?> user) {
        try {
            byte[] key = IOUtil.toByteArray((InputStream)pgpPart.getInputStream());
            this.getLog().debug("Checking PGP key for user: {}", (Object)user.getDisplayName());
            String userEmailAddress = user.getEmail().toLowerCase();
            PGPPublicKeyRingCollection keyRings = PgpUtil.loadPublicKeys(new ByteArrayInputStream(key));
            PGPPublicKeyRing keyRing = PgpUtil.getKeysForEmail(keyRings, userEmailAddress);
            if (keyRing == null) {
                throw new KeyException("Could not find a key ring for email address: " + userEmailAddress);
            }
            PgpEncryptionKey usedKey = new PgpEncryptionKey(keyRing, userEmailAddress);
            PGPPublicKey encKey = usedKey.getKey();
            if (encKey == null) {
                throw new KeyException("Could not find a valid encryption key.");
            }
            this.getLog().info("Setting PGP key for user: {}", (Object)user.getDisplayName());
            this.getUserProps().setBytes(EProperty.EMAIL_PGP_KEY, key, user);
            this.getUserProps().setLong(EProperty.EMAIL_PGP_KEY_ID, encKey.getKeyID(), user);
            this.getUserProps().setLong(EProperty.EMAIL_PGP_TIME_STAMP, System.currentTimeMillis(), user);
            this.getUserProps().setEnum(EProperty.EMAIL_PGP_KEY_SOURCE, EKeySource.USER, user);
            return this.createResponse(Response.Status.OK);
        }
        catch (IOException | PGPException e) {
            this.getLog().info("Key parsing failed. Error message: " + e.getMessage(), (Throwable)e);
            String msg = this.getI18n().getText("email-security-edit-webwork.error-pgp.message", e.getMessage());
            return this.createResponse(Response.Status.INTERNAL_SERVER_ERROR, msg);
        }
        catch (KeyException e) {
            this.getLog().info("No valid key found. Error message: " + e.getMessage(), (Throwable)e);
            I18nHelper i18n = this.getI18n();
            StringBuilder builder = new StringBuilder(500);
            builder.append("<p>");
            builder.append(i18n.getText("email-security-edit-webwork.error-keynotfound.message.pre"));
            builder.append("<p><ul>");
            builder.append("<li>");
            builder.append(i18n.getText("email-security-edit-webwork.error-keynotfound.message.list.email"));
            builder.append("</li><li>");
            builder.append(i18n.getText("email-security-edit-webwork.error-keynotfound.message.list.valid"));
            builder.append("</li><li>");
            builder.append(i18n.getText("email-security-edit-webwork.error-keynotfound.message.list.encryption"));
            builder.append("</li><li>");
            builder.append(i18n.getText("email-security-edit-webwork.error-keynotfound.message.list.revoked"));
            builder.append("</li>");
            builder.append("</ul><p>");
            builder.append(i18n.getText("email-security-edit-webwork.error-keynotfound.message.post"));
            builder.append("</p>");
            String msg = builder.toString();
            return this.createResponse(Response.Status.CONFLICT, msg);
        }
    }
}

