/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.gui.rest.profile;

import com.atlassian.plugins.rest.api.security.annotation.UnlicensedSiteAccess;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.user.IUser;
import net.savignano.snotify.jira.common.JiraUser;
import net.savignano.snotify.jira.gui.rest.profile.PublicUserEditing;

@Path(value="deleteSmimeCert")
public class PublicSmimeCertDelete
extends PublicUserEditing {
    @DELETE
    @UnlicensedSiteAccess
    public Response delete(@QueryParam(value="atl_token") String token, @Context HttpServletRequest req) {
        JiraUser user = null;
        try {
            if (!this.getAuthContext().isLoggedInUser()) {
                this.getLog().info("S/MIME certificate deletion not authorized.");
                return this.createResponse(Response.Status.UNAUTHORIZED);
            }
            user = new JiraUser(this.getAuthContext().getLoggedInUser());
            if (!this.hasMatchinXsrfToken(token, req.getSession(false))) {
                this.getLog().warn("XSRF token violation detected when deleting a S/MIME certificate for customer: {}", (Object)user);
                String msg = this.getI18n().getText("jsd-portal-email-security.error.xsrf.message");
                return this.createResponse(Response.Status.FORBIDDEN, msg);
            }
            if (!this.isUploadAllowed(ECryptographyType.SMIME)) {
                this.getLog().info("Deleting of S/MIME certificate is not allowed for user: {}", (Object)user);
                String msg = this.getI18n().getText("jsd-portal-email-security.error.smime.delete.message.adminForbidden");
                return this.createResponse(Response.Status.FORBIDDEN, msg);
            }
            return this.deleteSmimeCert(user);
        }
        catch (Exception e) {
            this.getLog().error("Error while deleting S/MIME certificate for user " + user + ". Error message: " + e.getMessage(), (Throwable)e);
            String msg = this.getI18n().getText("jsd-portal-email-security.error.smime.delete.message.generalException");
            return this.createResponse(Response.Status.INTERNAL_SERVER_ERROR, msg);
        }
    }

    private Response deleteSmimeCert(IUser<?> user) {
        this.getLog().info("Clearing S/MIME certificate for user: {}", (Object)user.getDisplayName());
        this.getUserProps().setBytes(EProperty.EMAIL_SMIME_CERT, null, user);
        this.getUserProps().setLong(EProperty.EMAIL_SMIME_TIME_STAMP, null, user);
        this.getUserProps().setEnum(EProperty.EMAIL_SMIME_KEY_SOURCE, null, user);
        return this.createResponse(Response.Status.OK);
    }
}

