/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.gui.rest.profile;

import com.atlassian.jira.util.IOUtil;
import com.atlassian.plugins.rest.api.multipart.FilePart;
import com.atlassian.plugins.rest.api.multipart.MultipartFormParam;
import com.atlassian.plugins.rest.api.security.annotation.UnlicensedSiteAccess;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyPurpose;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.util.SmimeUtil;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.user.IUser;
import net.savignano.snotify.jira.common.JiraUser;
import net.savignano.snotify.jira.gui.rest.profile.PublicUserEditing;
import org.apache.commons.lang3.StringUtils;

@Path(value="uploadSmimeCert")
public class PublicSmimeCertUpload
extends PublicUserEditing {
    @PUT
    @UnlicensedSiteAccess
    @Consumes(value={"multipart/form-data"})
    public Response upload(@MultipartFormParam(value="smime_certificate") FilePart smimeCertPart, @QueryParam(value="atl_token") String token, @Context HttpServletRequest req) throws IOException {
        JiraUser user = null;
        try {
            if (!this.getAuthContext().isLoggedInUser()) {
                this.getLog().info("S/MIME certificate upload not authorized.");
                return this.createResponse(Response.Status.UNAUTHORIZED);
            }
            user = new JiraUser(this.getAuthContext().getLoggedInUser());
            if (!this.hasMatchinXsrfToken(token, req.getSession(false))) {
                this.getLog().warn("XSRF token violation detected when uploading a S/MIME certificate for customer: {}", (Object)user);
                String msg = this.getI18n().getText("jsd-portal-email-security.error.xsrf.message");
                return this.createResponse(Response.Status.FORBIDDEN, msg);
            }
            if (!this.isUploadAllowed(ECryptographyType.SMIME)) {
                this.getLog().info("Uploading of S/MIME certificate is not allowed for user: {}", (Object)user);
                String msg = this.getI18n().getText("jsd-portal-email-security.error.smime.upload.message.adminForbidden");
                return this.createResponse(Response.Status.FORBIDDEN, msg);
            }
            if (smimeCertPart == null || smimeCertPart.getSize() == 0L) {
                String msg = this.getI18n().getText("jsd-portal-email-security.error.smime.upload.message.noFile");
                return this.createResponse(Response.Status.BAD_REQUEST, msg);
            }
            return this.setSmimeCert(smimeCertPart, user);
        }
        catch (Exception e) {
            this.getLog().error("Error while uploading S/MIME certificate for user " + user + ". Error message: " + e.getMessage(), (Throwable)e);
            String msg = this.getI18n().getText("jsd-portal-email-security.error.smime.upload.message.generalException");
            return this.createResponse(Response.Status.INTERNAL_SERVER_ERROR, msg);
        }
    }

    private Response setSmimeCert(FilePart smimePart, IUser<?> user) {
        byte[] cert;
        this.getLog().debug("Reading certificate data for user: " + user.getDisplayName());
        try {
            cert = IOUtil.toByteArray((InputStream)smimePart.getInputStream());
        }
        catch (IOException e) {
            this.getLog().info("Reading of user input failed.", (Throwable)e);
            String msg = this.getI18n().getText("email-security-edit-webwork.error-smime.message", e.getMessage());
            return this.createResponse(Response.Status.CONFLICT, msg);
        }
        this.getLog().debug("Checking certificate for user: " + user.getDisplayName());
        try {
            CertificateFactory fact = CertificateFactory.getInstance("X.509");
            X509Certificate certificate = (X509Certificate)fact.generateCertificate(new ByteArrayInputStream(cert));
            certificate.checkValidity();
            if (!SmimeUtil.isCertForEmail(certificate, user.getEmail())) {
                Object[] emails = SmimeUtil.getEmails(certificate);
                this.getLog().info("Email address {} not found in certificate. Email addresses found for subject: {}", (Object)user.getEmail(), (Object)StringUtils.join((Object[])emails, (String)", "));
                String msg = this.getI18n().getText("email-security-edit-webwork.error-email.message", StringUtils.join((Object[])emails, (String)", "), user.getEmail());
                return this.createResponse(Response.Status.CONFLICT, msg);
            }
            if (!SmimeUtil.isCertForPurpose(certificate, EKeyPurpose.ENCRYPTION)) {
                this.getLog().info("Certificate is not useable for encryption.");
                String msg = this.getI18n().getText("email-security-edit-webwork.error-encryption.message");
                return this.createResponse(Response.Status.CONFLICT, msg);
            }
        }
        catch (CertificateExpiredException e) {
            this.getLog().info("Certificate expired.", (Throwable)e);
            String msg = this.getI18n().getText("email-security-edit-webwork.error-expired.message");
            return this.createResponse(Response.Status.CONFLICT, msg);
        }
        catch (CertificateNotYetValidException e) {
            this.getLog().info("Certificate not yet valid.", (Throwable)e);
            String msg = this.getI18n().getText("email-security-edit-webwork.error-notyetvalid.message");
            return this.createResponse(Response.Status.CONFLICT, msg);
        }
        catch (CertificateException e) {
            this.getLog().info("Certificate parsing failed.", (Throwable)e);
            String msg = this.getI18n().getText("email-security-edit-webwork.error-smime.message", e.getMessage());
            return this.createResponse(Response.Status.CONFLICT, msg);
        }
        this.getLog().info("Setting S/MIME certificate for user: {}", (Object)user.getDisplayName());
        this.getUserProps().setBytes(EProperty.EMAIL_SMIME_CERT, cert, user);
        this.getUserProps().setLong(EProperty.EMAIL_SMIME_TIME_STAMP, System.currentTimeMillis(), user);
        this.getUserProps().setEnum(EProperty.EMAIL_SMIME_KEY_SOURCE, EKeySource.USER, user);
        return this.createResponse(Response.Status.OK);
    }
}

