/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.gui.webpanel;

import com.atlassian.jira.bc.license.JiraServerIdProvider;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.SimpleXsrfTokenGenerator;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Map;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.enums.EEncryptionTypePriority;
import net.savignano.snotify.atlassian.gui.key.info.IKeyValueStyle;
import net.savignano.snotify.jira.common.JiraUser;
import net.savignano.snotify.jira.gui.key.info.JsdHtmlKeyValueStyle;
import net.savignano.snotify.jira.gui.webpanel.EmailSettingsContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsdEmailSettingsContextProvider
extends EmailSettingsContextProvider {
    private static final String IS_CHOICE_ENABLED = "isChoiceEnabled";
    private static final String IS_SMIME_SELECTED = "isSmimeSelected";
    private static final String IS_PGP_SELECTED = "isPgpSelected";
    private static final String ATL_TOKEN_NAME = "atlTokeName";
    private static final String XSRF_TOKEN = "xsrfToken";
    private static final Logger log = LoggerFactory.getLogger(JsdEmailSettingsContextProvider.class);
    private static final String JSD_CUSTOMER_USER_KEY = "user";

    @Override
    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Map<String, Object> contextMap = super.getContextMap(context);
        contextMap.put(IS_CHOICE_ENABLED, this.isChoiceEnabled());
        contextMap.put(IS_SMIME_SELECTED, this.isSmimeSelected());
        contextMap.put(IS_PGP_SELECTED, this.isPgpSelected());
        contextMap.put(ATL_TOKEN_NAME, this.getXsrfTokenName());
        contextMap.put(XSRF_TOKEN, this.createXsrfToken());
        return contextMap;
    }

    private EEncryptionTypePriority getTypePriority() {
        return this.getAppProps().getEnum(EProperty.ENCRYPTION_TYPE_PRIORITY, EEncryptionTypePriority.class);
    }

    private boolean isAllowPgpUpload() {
        return this.getAppProps().getBoolean(EProperty.ALLOW_JSD_PGP_PUBLIC_KEY_OVERWRITE) || this.getAppProps().getBoolean(EProperty.LITE_MODE);
    }

    private boolean isAllowSmimeUpload() {
        return this.getAppProps().getBoolean(EProperty.ALLOW_JSD_SMIME_CERTIFICATE_OVERWRITE) || this.getAppProps().getBoolean(EProperty.LITE_MODE);
    }

    private boolean isChoiceEnabled() {
        switch (this.getTypePriority()) {
            case SMIME_PREFERRED: 
            case PGP_PREFERRED: {
                return this.isAllowPgpUpload() && this.isAllowSmimeUpload();
            }
            case SMIME_ONLY: 
            case PGP_ONLY: {
                return false;
            }
        }
        log.warn("Unknwon value for 'Encryption Type Priority' found. Value found was '" + (Object)((Object)this.getTypePriority()) + "'. It is not yet implemented,");
        return true;
    }

    private boolean isSmimeSelected() {
        switch (this.getTypePriority()) {
            case SMIME_ONLY: {
                return true;
            }
            case PGP_ONLY: {
                return false;
            }
            case SMIME_PREFERRED: {
                return this.isAllowSmimeUpload() || !this.isAllowPgpUpload();
            }
            case PGP_PREFERRED: {
                return this.isAllowSmimeUpload() && !this.isAllowPgpUpload();
            }
        }
        log.warn("Unknwon value for 'Encryption Type Priority' found. Value found was '" + (Object)((Object)this.getTypePriority()) + "'. It is not yet implemented,");
        return true;
    }

    private boolean isPgpSelected() {
        switch (this.getTypePriority()) {
            case SMIME_ONLY: {
                return false;
            }
            case PGP_ONLY: {
                return true;
            }
            case SMIME_PREFERRED: {
                return this.isAllowPgpUpload() && !this.isAllowSmimeUpload();
            }
            case PGP_PREFERRED: {
                return this.isAllowPgpUpload() || !this.isAllowSmimeUpload();
            }
        }
        log.warn("Unknwon value for 'Encryption Type Priority' found. Value found was '" + (Object)((Object)this.getTypePriority()) + "'. It is not yet implemented,");
        return false;
    }

    private String getXsrfTokenName() {
        return "atl_token";
    }

    private String createXsrfToken() {
        JiraAuthenticationContext context = ComponentAccessor.getJiraAuthenticationContext();
        JiraServerIdProvider provider = (JiraServerIdProvider)ComponentAccessor.getComponent(JiraServerIdProvider.class);
        FeatureManager manager = (FeatureManager)ComponentAccessor.getComponent(FeatureManager.class);
        SimpleXsrfTokenGenerator tokenGenerator = new SimpleXsrfTokenGenerator(context, provider, manager);
        return tokenGenerator.generateToken();
    }

    @Override
    protected JiraUser getCurrentUser(Map<String, Object> context) {
        if (context.get(JSD_CUSTOMER_USER_KEY) != null) {
            return new JiraUser((ApplicationUser)context.get(JSD_CUSTOMER_USER_KEY));
        }
        return super.getCurrentUser(context);
    }

    @Override
    protected JiraUser getProfileUser(Map<String, Object> context) {
        if (context.get(JSD_CUSTOMER_USER_KEY) != null) {
            return new JiraUser((ApplicationUser)context.get(JSD_CUSTOMER_USER_KEY));
        }
        return super.getProfileUser(context);
    }

    @Override
    protected IKeyValueStyle getKeyValueStyle() {
        return new JsdHtmlKeyValueStyle();
    }
}

