/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.gui.webwork;

import com.atlassian.mail.MailFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import java.io.IOException;
import javax.inject.Inject;
import net.savignano.cryptography.version.NormalizedVersion;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.gui.templates.IAdminTemplate;
import net.savignano.snotify.jira.gui.webwork.SnotifyWebAction;

public class SnotifyAdminSettingsAction
extends SnotifyWebAction
implements IAdminTemplate {
    private static final long serialVersionUID = 7689502538460790854L;
    @Inject
    @ComponentImport
    private WebSudoManager webSudoManager;

    protected void webSudoProceed(Runnable code) {
        try {
            this.webSudo(code);
        }
        catch (WebSudoSessionException e) {
            this.webSudoManager.enforceWebSudoProtection(this.getHttpRequest(), this.getHttpResponse());
        }
    }

    protected void webSudoForbidden(Runnable code) {
        try {
            this.webSudo(code);
        }
        catch (WebSudoSessionException e) {
            try {
                this.getHttpResponse().sendError(403);
            }
            catch (IOException e1) {
                this.getLog().error(e.getMessage(), (Throwable)e1);
            }
        }
    }

    private void webSudo(Runnable code) throws WebSudoSessionException {
        this.webSudoManager.willExecuteWebSudoRequest(this.getHttpRequest());
        code.run();
    }

    @Override
    public String getGetStartedLink() {
        String baseUrl = this.getApplicationProperties().getString("jira.baseurl");
        return baseUrl + "/secure/admin/SnotifyInstallationGuideAction.jspa";
    }

    @Override
    public boolean isMailerLibPresent() {
        return this.getMailerVersion() != null;
    }

    @Override
    public boolean isMailServerPresent() {
        return MailFactory.getServerManager().getDefaultSMTPMailServer() != null;
    }

    @Override
    public boolean isVersionMatch() {
        if (!this.getAppProps().getBoolean(EProperty.DEV_MODE)) {
            return IAdminTemplate.super.isVersionMatch();
        }
        NormalizedVersion guiVersion = new NormalizedVersion(this.getGuiVersion());
        NormalizedVersion mailerVersion = new NormalizedVersion(this.getMailerVersion());
        return guiVersion.equals(mailerVersion);
    }

    @Override
    public String getGuiVersion() {
        return this.getAppProps().getString(EProperty.GUI_VERSION);
    }

    @Override
    public String getMailerVersion() {
        return this.getAppProps().getString(EProperty.MAILER_VERSION);
    }

    @Override
    public boolean isDisabled() {
        return this.getAppProps().getBoolean(EProperty.DISABLE_SNOTIFY);
    }

    @Override
    public boolean isFrozen() {
        return this.getAppProps().getBoolean(EProperty.FREEZE_SNOTIFY);
    }

    public boolean isLiteMode() {
        return this.getAppProps().getBoolean(EProperty.LITE_MODE);
    }
}

