/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.gui.webwork;

import com.atlassian.jira.bc.license.JiraServerIdProvider;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.SimpleXsrfTokenGenerator;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import javax.inject.Inject;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.gui.templates.IUpdatedTemplate;
import net.savignano.snotify.jira.common.SnotifyAppProperties;
import net.savignano.snotify.jira.common.SnotifyI18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyWebAction
extends JiraWebActionSupport
implements IUpdatedTemplate {
    private static final long serialVersionUID = 1725845202474877661L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Inject
    private ISnotifyAppProperties appProps;
    private ISnotifyI18n i18n;
    private XsrfTokenGenerator tokenGenerator;
    private boolean showUpdated;

    protected Logger getLog() {
        return this.log;
    }

    public ISnotifyAppProperties getAppProps() {
        if (this.appProps == null) {
            this.appProps = new SnotifyAppProperties();
        }
        return this.appProps;
    }

    public ISnotifyI18n getSnotifyI18n() {
        if (this.i18n == null) {
            this.i18n = new SnotifyI18n((I18nHelper)this);
        }
        return this.i18n;
    }

    @Override
    public boolean isShowUpdated() {
        return this.showUpdated;
    }

    public void setShowUpdated(boolean showUpdated) {
        this.showUpdated = showUpdated;
    }

    public String getSecurityToken() {
        return this.getTokenGenerator().generateToken(this.getHttpRequest());
    }

    public String getTokenName() {
        return "atl_token";
    }

    private XsrfTokenGenerator getTokenGenerator() {
        if (this.tokenGenerator == null) {
            this.tokenGenerator = this.createTokenGenerator();
        }
        return this.tokenGenerator;
    }

    private XsrfTokenGenerator createTokenGenerator() {
        JiraAuthenticationContext context = ComponentAccessor.getJiraAuthenticationContext();
        JiraServerIdProvider provider = (JiraServerIdProvider)ComponentAccessor.getComponent(JiraServerIdProvider.class);
        FeatureManager manager = (FeatureManager)ComponentAccessor.getComponent(FeatureManager.class);
        SimpleXsrfTokenGenerator tokenGenerator = new SimpleXsrfTokenGenerator(context, provider, manager);
        return tokenGenerator;
    }
}

