/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.gui.webwork;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletResponse;
import net.savignano.cryptography.Constants;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ASnotifyAppProperties;
import net.savignano.snotify.atlassian.gui.SupportBuilder;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatusBuilder;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatusDisplay;
import net.savignano.snotify.jira.gui.webwork.SnotifyAdminSettingsAction;
import org.apache.commons.lang3.StringUtils;

public class TweakSnotifyAction
extends SnotifyAdminSettingsAction {
    private static final long serialVersionUID = -3631917729713999018L;
    private static final String KEY_PARAM = "key";
    private static final String VALUE_PARAM = "value";
    private String key;
    private String value;
    private String errorMessage;

    @SupportedMethods(value={RequestMethod.GET})
    public String doInput() {
        this.webSudoProceed(this::input);
        return "input";
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doAdd() {
        this.webSudoForbidden(this::add);
        return "input";
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doUpdate() {
        this.webSudoForbidden(this::update);
        return "input";
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doDelete() {
        this.webSudoForbidden(this::delete);
        return "input";
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doSupport() {
        this.webSudoForbidden(this::support);
        return null;
    }

    private void input() {
    }

    private void add() {
        String key = StringUtils.stripToNull((String)this.getHttpRequest().getParameter(KEY_PARAM));
        String value = StringUtils.stripToNull((String)this.getHttpRequest().getParameter(VALUE_PARAM));
        if (key == null || value == null) {
            this.getLog().debug("Key or Value is considered empty. Tweak will not be added.");
            VerificationStatusBuilder builder = new VerificationStatusBuilder(this.getSnotifyI18n());
            builder.error();
            builder.title("snotify-tweak-webwork.input.error.missingKeyValue.title", new Object[0]);
            builder.message("snotify-tweak-webwork.input.error.missingKeyValue.message", key);
            this.errorMessage = VerificationStatusDisplay.getHtml(builder.build());
            this.key = key;
            this.value = value;
            return;
        }
        this.getLog().debug("Adding key/value pair to tweak: {} = {}", (Object)key, (Object)value);
        this.setProperty(key, value);
    }

    private void update() {
        String key = StringUtils.stripToNull((String)this.getHttpRequest().getParameter(KEY_PARAM));
        String value = StringUtils.stripToNull((String)this.getHttpRequest().getParameter(VALUE_PARAM));
        if (key == null || value == null) {
            this.getLog().debug("Key or Value is considered empty. Tweak will not be updated.");
            VerificationStatusBuilder builder = new VerificationStatusBuilder(this.getSnotifyI18n());
            builder.error();
            builder.title("snotify-tweak-webwork.input.error.missingKeyValue.title", new Object[0]);
            builder.message("snotify-tweak-webwork.input.error.missingKeyValue.message", key);
            this.errorMessage = VerificationStatusDisplay.getHtml(builder.build());
            return;
        }
        this.getLog().debug("Updating key/value pair of tweak: {} = {}", (Object)key, (Object)value);
        this.setProperty(key, value);
    }

    private void setProperty(String key, String value) {
        Optional<EProperty> prop = EProperty.getProperty("tweak." + key);
        if (!prop.isPresent()) {
            this.getLog().debug("Key {} does not represent a tweak.", (Object)key);
            VerificationStatusBuilder builder = new VerificationStatusBuilder(this.getSnotifyI18n());
            builder.error();
            builder.title("snotify-tweak-webwork.input.error.notAProperty.title", new Object[0]);
            builder.message("snotify-tweak-webwork.input.error.notAProperty.message", key);
            this.errorMessage = VerificationStatusDisplay.getHtml(builder.build());
            this.key = key;
            this.value = value;
            return;
        }
        ((ASnotifyAppProperties)this.getAppProps()).setAsString(prop.get(), value);
        Map<String, String> tweaks = this.getUsedTweaks();
        tweaks.put(key, value);
        this.setUsedTweaks(tweaks);
        this.setShowUpdated(true);
    }

    private void delete() {
        String key = StringUtils.stripToNull((String)this.getHttpRequest().getParameter(KEY_PARAM));
        if (key == null) {
            this.getLog().debug("Key is considered empty. Tweak will not be removed.");
            return;
        }
        this.getLog().debug("Removing key from tweaks: {}", (Object)key);
        Optional<EProperty> prop = EProperty.getProperty("tweak." + key);
        if (prop.isPresent()) {
            ((ASnotifyAppProperties)this.getAppProps()).setAsString(prop.get(), null);
        } else {
            this.getLog().debug("Key {} does not represent a tweak.", (Object)key);
        }
        Map<String, String> tweaks = this.getUsedTweaks();
        tweaks.remove(key);
        this.setUsedTweaks(tweaks);
        this.setShowUpdated(true);
    }

    private void support() {
        this.getLog().debug("Creating support file.");
        String data = this.createSupportData();
        byte[] contents = data.getBytes(Constants.UTF8_CHARSET);
        HttpServletResponse resp = this.getHttpResponse();
        resp.addHeader("Content-Type", "text/plain; charset=UTF-8");
        resp.addHeader("Content-Length", String.valueOf(contents.length));
        resp.addHeader("Cache-Control", "no-cache");
        resp.addHeader("Pragma", "no-cache");
        resp.addHeader("Expires", "-1");
        resp.addHeader("Content-Disposition", "attachment; filename=\"snotify-support.txt\"");
        try {
            resp.getWriter().append(data);
            resp.getWriter().flush();
        }
        catch (IOException e) {
            this.getLog().error("Could not create S/Notify support file. Error message: " + e.getMessage(), (Throwable)e);
        }
    }

    private String createSupportData() {
        Supplier<String> platform = () -> {
            BuildUtilsInfo buildUtils = (BuildUtilsInfo)ComponentAccessor.getComponent(BuildUtilsInfo.class);
            return "Jira " + buildUtils.getVersion();
        };
        PluginLicenseManager licenseManager = (PluginLicenseManager)ComponentAccessor.getComponent(PluginLicenseManager.class);
        return SupportBuilder.create().includeLicenseId(licenseManager).includePlatform(platform).includeProperties(this.getAppProps()).build();
    }

    public Collection<Map.Entry<String, String>> getTweakEntries() {
        return this.getUsedTweaks().entrySet();
    }

    @HtmlSafe
    public String getErrorMessage() {
        return this.errorMessage == null ? "" : this.errorMessage;
    }

    private Map<String, String> getUsedTweaks() {
        TreeMap<String, String> tweaks = new TreeMap<String, String>();
        String tweakString = this.getAppProps().getUnlimitedString(EProperty.TWEAK_OVERVIEW);
        if (tweakString != null) {
            for (String tweak : tweakString.split("\\;")) {
                Optional<EProperty> prop = EProperty.getProperty("tweak." + tweak);
                if (prop.isPresent()) {
                    tweaks.put(tweak, ((ASnotifyAppProperties)this.getAppProps()).getAsString(prop.get()));
                    continue;
                }
                this.getLog().info("Key {} is not considered a tweak. It will be skipped.");
            }
        }
        return tweaks;
    }

    private void setUsedTweaks(Map<String, String> tweaks) {
        if (tweaks == null || tweaks.isEmpty()) {
            this.getAppProps().setUnlimitedString(EProperty.TWEAK_OVERVIEW, null);
        } else {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> entry : tweaks.entrySet()) {
                builder.append(entry.getKey());
                builder.append(';');
            }
            builder.deleteCharAt(builder.length() - 1);
            this.getAppProps().setUnlimitedString(EProperty.TWEAK_OVERVIEW, builder.toString());
        }
    }

    public String getKey() {
        return this.key == null ? "" : this.key;
    }

    public String getValue() {
        return this.value == null ? "" : this.value;
    }
}

