/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.mail.smime.examples;

import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.savignano.thirdparty.org.bouncycastle.cert.X509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import net.savignano.thirdparty.org.bouncycastle.cms.SignerInformation;
import net.savignano.thirdparty.org.bouncycastle.cms.SignerInformationStore;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMESignedParser;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.util.SharedFileInputStream;
import net.savignano.thirdparty.org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import net.savignano.thirdparty.org.bouncycastle.util.Store;

public class ReadLargeSignedMail {
    private static final String BC = "SAVIGNANO-BC";

    private static void verify(SMIMESignedParser s) throws Exception {
        Store certs = s.getCertificates();
        SignerInformationStore signers = s.getSignerInfos();
        Collection<SignerInformation> c = signers.getSigners();
        for (SignerInformation signer : c) {
            Collection certCollection = certs.getMatches(signer.getSID());
            Iterator certIt = certCollection.iterator();
            X509Certificate cert = new JcaX509CertificateConverter().setProvider(BC).getCertificate((X509CertificateHolder)certIt.next());
            if (signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(cert))) {
                System.out.println("signature verified");
                continue;
            }
            System.out.println("signature failed!");
        }
    }

    public static void main(String[] args) throws Exception {
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(session, (InputStream)new SharedFileInputStream("signed.message"));
        if (msg.isMimeType("multipart/signed")) {
            SMIMESignedParser s = new SMIMESignedParser(new JcaDigestCalculatorProviderBuilder().build(), (MimeMultipart)msg.getContent());
            System.out.println("Status:");
            ReadLargeSignedMail.verify(s);
        } else if (msg.isMimeType("application/pkcs7-mime")) {
            SMIMESignedParser s = new SMIMESignedParser(new JcaDigestCalculatorProviderBuilder().build(), (Part)msg);
            System.out.println("Status:");
            ReadLargeSignedMail.verify(s);
        } else {
            System.err.println("Not a signed message!");
        }
    }
}

