/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.KeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus.HT;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus.PK;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus.SK;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusEngine;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusKeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusPublicKeyParameters;

public class SPHINCSPlusKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;
    private SPHINCSPlusParameters parameters;

    @Override
    public void init(KeyGenerationParameters param) {
        this.random = param.getRandom();
        this.parameters = ((SPHINCSPlusKeyGenerationParameters)param).getParameters();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        SK sk;
        byte[] pkSeed;
        SPHINCSPlusEngine engine = this.parameters.getEngine();
        if (engine instanceof SPHINCSPlusEngine.HarakaSEngine) {
            byte[] tmparray = this.sec_rand(engine.N * 3);
            byte[] skseed = new byte[engine.N];
            byte[] skprf = new byte[engine.N];
            pkSeed = new byte[engine.N];
            System.arraycopy(tmparray, 0, skseed, 0, engine.N);
            System.arraycopy(tmparray, engine.N, skprf, 0, engine.N);
            System.arraycopy(tmparray, engine.N << 1, pkSeed, 0, engine.N);
            sk = new SK(skseed, skprf);
        } else {
            sk = new SK(this.sec_rand(engine.N), this.sec_rand(engine.N));
            pkSeed = this.sec_rand(engine.N);
        }
        engine.init(pkSeed);
        PK pk = new PK(pkSeed, new HT((SPHINCSPlusEngine)engine, (byte[])sk.seed, (byte[])pkSeed).htPubKey);
        return new AsymmetricCipherKeyPair(new SPHINCSPlusPublicKeyParameters(this.parameters, pk), new SPHINCSPlusPrivateKeyParameters(this.parameters, sk, pk));
    }

    private byte[] sec_rand(int n) {
        byte[] rv = new byte[n];
        this.random.nextBytes(rv);
        return rv;
    }
}

