/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader;

import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.loader.IKeyLoader;
import net.savignano.cryptography.key.loader.KeyLoaderTransformer;

public class StaticKeyLoader<T extends ICryptographyKey<?>>
implements IKeyLoader<T, Void> {
    private final T key;

    public static final <T extends ICryptographyKey<?>, U> IKeyLoader<T, U> transform(T key) {
        return StaticKeyLoader.transform(new StaticKeyLoader<T>(key));
    }

    public static final <T extends ICryptographyKey<?>, U> IKeyLoader<T, U> transform(StaticKeyLoader<T> loader) {
        return KeyLoaderTransformer.create(loader, o -> null);
    }

    public StaticKeyLoader(T key) {
        this.key = key;
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null.");
        }
    }

    @Override
    public T loadKey(Void forId) {
        return this.key;
    }

    @Override
    public EKeySource getKeySource() {
        return this.key.getKeySource();
    }

    @Override
    public ECryptographyType getCryptography() {
        return this.key.getCryptography();
    }
}

