/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.mail.IMailCryptography;
import net.savignano.cryptography.mail.ISessionProvider;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.cryptography.version.ProductInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseMailCryptography
implements IMailCryptography,
ISessionProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Session session;
    private final ECryptographyType cryptography;
    private ProductInformation productInfo;

    protected BaseMailCryptography(Session session, ECryptographyType cryptography) {
        if (session == null) {
            throw new IllegalArgumentException("Session must not be null.");
        }
        if (cryptography == null) {
            throw new IllegalArgumentException("Cryptography must not be null.");
        }
        this.session = session;
        this.cryptography = cryptography;
    }

    protected void includeCryptographyHeader(MimeMessage msg, String headerName, String valuePattern, Object ... additonalValues) throws MessagingException {
        ProductInformation info = this.getProductInfo();
        if (info == null) {
            return;
        }
        Object[] values = new Object[additonalValues.length + 3];
        values[0] = info.getProduct();
        values[1] = info.getVersion();
        values[2] = info.getHost();
        if (additonalValues.length != 0) {
            System.arraycopy(additonalValues, 0, values, 3, additonalValues.length);
        }
        MessageUtil.setHeader((Message)msg, headerName, valuePattern, values);
    }

    protected void traceMessage(MimeMessage msg, String displayPattern) {
        if (this.getLog().isTraceEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                msg.writeTo((OutputStream)baos);
                String msgStr = baos.toString();
                if (displayPattern == null) {
                    this.getLog().trace(msgStr);
                } else {
                    this.getLog().trace(displayPattern, (Object)msgStr);
                }
            }
            catch (IOException | MessagingException e) {
                this.getLog().error("Could not trace message with msg ID \"" + MessageUtil.getMessageId((Message)msg) + "\". Error message: " + e.getMessage(), e);
            }
        }
    }

    protected Logger getLog() {
        return this.log;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public ECryptographyType getCryptography() {
        return this.cryptography;
    }

    public ProductInformation getProductInfo() {
        return this.productInfo;
    }

    public void setProductInfo(ProductInformation productInfo) {
        this.productInfo = productInfo;
    }
}

