/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.encrypt;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.key.IPublicCryptographyKey;
import net.savignano.cryptography.mail.BaseCryptographyResult;
import net.savignano.cryptography.mail.BaseMailCryptography;
import net.savignano.cryptography.mail.encrypt.IMailEncryptor;
import net.savignano.cryptography.util.MessageUtil;

public abstract class AMailEncryptor<T extends IPublicCryptographyKey<?>, R extends BaseCryptographyResult>
extends BaseMailCryptography
implements IMailEncryptor<T, R> {
    private static final String MAIL_HEADER_ENCRYPTED_PATTERN = "by {0} using {3} encryption";
    private static final String MAIL_HEADER_ENCRYPTED_DEBUG_PATTERN = "by {0} {1} at {2} using {3} encryption with {4}";
    private T senderKey;

    protected AMailEncryptor(Session session, ECryptographyType cryptography) {
        super(session, cryptography);
    }

    @Override
    public void encryptMessage(MimeMessage msg, T key) throws IOException, MessagingException {
        if (msg == null) {
            return;
        }
        if (key == null) {
            throw new MessagingException("Cannot encrypt message because no key was provided.");
        }
        if (!key.isValid()) {
            throw new MessagingException("Cannot encrypt message because of key having validity: " + (Object)((Object)key.getKeyValidity()));
        }
        R result = this.createResult(msg);
        List<IPublicCryptographyKey> keys = this.getSenderKey().isPresent() && ((IPublicCryptographyKey)this.getSenderKey().get()).isValid() ? Arrays.asList(key, (IPublicCryptographyKey)this.getSenderKey().get()) : Arrays.asList(key);
        this.encrypt(result, keys);
        if (((BaseCryptographyResult)result).getException() != null) {
            String errMsg = "Could not encrypt message with msg ID \"" + MessageUtil.getMessageId((Message)((BaseCryptographyResult)result).getMessage()) + "\". Error message: " + ((BaseCryptographyResult)result).getException().getMessage();
            throw new MessagingException(errMsg, ((BaseCryptographyResult)result).getException());
        }
    }

    @Override
    public R encryptMessage(MimeMessage msg, Collection<T> keys) {
        R result = this.createResult(msg);
        if (msg == null) {
            ((BaseCryptographyResult)result).setException(new IllegalArgumentException("Cannot encrypt message because no message was provided."));
            return result;
        }
        if (keys == null || keys.isEmpty()) {
            ((BaseCryptographyResult)result).setException(new IllegalArgumentException("Cannot encrypt message because no keys were provided."));
            return result;
        }
        for (IPublicCryptographyKey key : keys) {
            if (key.isValid()) continue;
            ((BaseCryptographyResult)result).setException(new IllegalArgumentException("Cannot encrypt message because not all keys were valid. Not valid key: " + key));
            return result;
        }
        return this.encrypt(result, keys);
    }

    private R encrypt(R result, Collection<T> validKeys) {
        MimeMessage msg = ((BaseCryptographyResult)result).getMessage();
        String msgId = MessageUtil.getMessageId((Message)msg);
        this.getLog().info("Encrypting message with ID \"{}\" with {}.", (Object)msgId, (Object)this.getCryptography());
        this.traceMessage(msg, "Original email:\n{}");
        try {
            this.encrypt(validKeys, result);
            msg.saveChanges();
            msg.setHeader("Message-ID", msgId);
        }
        catch (Exception e) {
            ((BaseCryptographyResult)result).setException(e);
        }
        this.getLog().info("Encryption result for message with ID \"{}\": {}", (Object)msgId, result);
        this.traceMessage(msg, "Final email:\n{}");
        return result;
    }

    protected abstract R createResult(MimeMessage var1);

    protected abstract void encrypt(Collection<T> var1, R var2) throws Exception;

    protected void includeEncryptionHeader(MimeMessage msg, String encryptionAlgorithm) throws MessagingException {
        String headerPattern = this.isVerboseHeader() ? MAIL_HEADER_ENCRYPTED_DEBUG_PATTERN : MAIL_HEADER_ENCRYPTED_PATTERN;
        this.includeCryptographyHeader(msg, "X-Encrypted", headerPattern, new Object[]{this.getCryptography(), encryptionAlgorithm});
    }

    protected boolean isVerboseHeader() {
        return this.getLog().isDebugEnabled();
    }

    public Optional<T> getSenderKey() {
        return Optional.ofNullable(this.senderKey);
    }

    @Deprecated
    public void setSenderPublicKey(T senderKey) {
        this.senderKey = senderKey;
    }
}

