/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.visitor;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.mail.visitor.ContentTypeVisitor;

public class ManipulateMessageVisitor
extends ContentTypeVisitor {
    private boolean changed;

    @Override
    public void visit(MimeMessage msg) throws Exception {
        super.visit(msg);
        if (this.isChanged()) {
            msg.saveChanges();
            if (this.getLog().isTraceEnabled()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                msg.writeTo((OutputStream)baos);
                this.getLog().trace("Message changed. Final email:\n{}\n", (Object)baos.toString());
            }
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.setChanged(false);
    }

    public boolean isChanged() {
        return this.changed;
    }

    protected void setChanged(boolean changed) {
        this.changed = changed;
    }
}

