/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Optional;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.mail.ISessionProvider;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.cryptography.version.IVersion;
import net.savignano.cryptography.version.ProductInformation;
import net.savignano.snotify.atlassian.common.enums.EEncryptionFailureBehavior;
import net.savignano.snotify.atlassian.common.enums.EEncryptionTypePriority;
import net.savignano.snotify.atlassian.mailer.MessageAndAddress;
import net.savignano.snotify.atlassian.mailer.SnotifyMimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMailer
implements ISessionProvider,
IVersion {
    private static final Logger log = LoggerFactory.getLogger(AMailer.class);
    private final Session session;
    private EEncryptionTypePriority typePriority;
    private EEncryptionFailureBehavior failureBehavior;
    private Boolean disabled;
    private Boolean frozen;
    private Boolean liteMode;
    private Boolean dryRun;
    private Boolean additionalSigningSmime;
    private Boolean additionalSigningPgp;
    private ProductInformation productInformation;

    public AMailer(Session session) {
        this.session = session;
        if (Thread.currentThread().getContextClassLoader() == null) {
            ClassLoader classLoader = Message.class.getClassLoader();
            log.warn("Context class loader of current thread is null. Setting context class loader to this class' class loader of javax.mail.Message: {}", (Object)classLoader);
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public MessageAndAddress[] getMessages(MimeMessage message, Address[] addresses) {
        if (message == null) {
            log.debug("Message is null.");
            return new MessageAndAddress[0];
        }
        if (addresses == null || addresses.length == 0) {
            log.debug("Addresses is null or zero length.");
            return new MessageAndAddress[0];
        }
        if (this.isDisabled()) {
            log.warn("S/Notify is disabled. Emails will not be encrypted.");
            MessageAndAddress[] result = new MessageAndAddress[addresses.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new MessageAndAddress(message, addresses[i]);
            }
            return result;
        }
        if (this.isFrozen()) {
            log.warn("Cannot encrypt emails due to licensing error in S/Notify. Handling unencrypted emails as: " + (Object)((Object)this.getFailureBehavior()));
        }
        if (this.isLiteMode()) {
            log.info("S/Notify is in 'lite'-mode. Limited functionality.");
        }
        if (this.isDryRun()) {
            log.info("S/Notify is in 'dry run'-mode. Emails will not be sent.");
        }
        ArrayList<MessageAndAddress> result = new ArrayList<MessageAndAddress>();
        for (Address address : addresses) {
            MessageAndAddress messageAndAddress = new MessageAndAddress();
            messageAndAddress.address = address;
            messageAndAddress.message = message;
            result.add(messageAndAddress);
            this.handleMessage(messageAndAddress);
        }
        return result.toArray(new MessageAndAddress[result.size()]);
    }

    private void handleMessage(MessageAndAddress msgAndAddress) {
        MailerData data = this.createDefaultEncryptionData(msgAndAddress);
        if (this.isFrozen()) {
            this.handleLicenseError(data);
        } else if (this.isEmailBlocked(data.toAddress) != EEncryptionFailureBehavior.ALLOW) {
            this.handleBlockedEmail(data);
        } else {
            this.handleMessage(msgAndAddress, data);
        }
        if (data.encrypt && data.encryptValidity != EKeyValidity.VALID) {
            this.handleEncryptionFailure(msgAndAddress, data);
        }
        if (!data.send) {
            this.markEmailAsDoNotSend(msgAndAddress);
        }
    }

    private MailerData createDefaultEncryptionData(MessageAndAddress msgAndAddress) {
        Optional<Address> from = MessageUtil.getFrom(msgAndAddress.message);
        MailerData data = new MailerData();
        data.message = this.wrap(msgAndAddress.message);
        data.toAddress = msgAndAddress.address;
        data.fromAddress = from.isPresent() ? from.get() : null;
        data.encrypt = data.toAddress != null && this.isEncryptionDesired(msgAndAddress);
        data.sign = data.fromAddress != null && this.isSigningDesired(msgAndAddress);
        data.protect = (data.encrypt || data.sign) && this.isProtectionDesired(msgAndAddress);
        data.failureBehavior = this.getFailureBehavior();
        data.send = !this.isDryRun();
        return data;
    }

    private void handleLicenseError(MailerData data) {
        log.warn("S/Notify has detected a license error. Emails will not get encrypted.");
        data.encrypt = true;
        data.sign = false;
        data.protect = false;
        data.encryptValidity = EKeyValidity.ERROR;
        data.signValidity = EKeyValidity.ERROR;
    }

    private void handleBlockedEmail(MailerData data) {
        log.info("Email for \"{}\" is on blocked list. It will not get sent.", (Object)data.toAddress);
        data.encrypt = true;
        data.sign = false;
        data.protect = false;
        data.encryptValidity = EKeyValidity.ERROR;
        data.signValidity = EKeyValidity.ERROR;
        data.failureBehavior = this.isEmailBlocked(data.toAddress);
    }

    private void handleMessage(MessageAndAddress msgAndAddress, MailerData data) {
        log.debug("Starting email encryption to address: \"{}\"", (Object)msgAndAddress.address);
        try {
            this.processMessage(data, msgAndAddress);
            if (data.encrypt && data.encryptValidity == EKeyValidity.VALID || data.sign && data.signValidity == EKeyValidity.VALID) {
                msgAndAddress.message = data.message;
            }
        }
        catch (Exception e) {
            log.error("Error processing email for address \"" + msgAndAddress.address + "\": " + e.getMessage(), (Throwable)e);
            data.encryptValidity = EKeyValidity.ERROR;
            data.signValidity = EKeyValidity.ERROR;
        }
        if (data.sign && (data.signValidity == EKeyValidity.ERROR || data.signValidity == EKeyValidity.INVALID)) {
            log.warn("Could not sign email for \"{}\" from \"{}\".", (Object)data.toAddress, (Object)data.fromAddress);
        }
    }

    private void handleEncryptionFailure(MessageAndAddress msgAndAddress, MailerData data) {
        log.debug("No valid encryption for address {}. Using failure behavior {} to process email.", (Object)msgAndAddress.address, (Object)data.failureBehavior);
        switch (data.failureBehavior) {
            case ALLOW: {
                log.info("Could not encrypt email for \"{}\". Unencrypted email will be sent.", (Object)msgAndAddress.address);
                break;
            }
            case BLOCK: {
                log.warn("Could not encrypt email for \"{}\". Email will not be sent.", (Object)msgAndAddress.address);
                data.send = false;
                break;
            }
            case REPORT: {
                log.warn("Could not encrypt email for \"{}\". Creating error report.", (Object)msgAndAddress.address);
                try {
                    msgAndAddress.message = this.getFailureMessage(msgAndAddress, data.encryptValidity);
                }
                catch (MessagingException e) {
                    log.error("Error creating report email for email address \"" + msgAndAddress.address + "\". Error message: " + e.getMessage(), (Throwable)e);
                }
                if (!data.sign) break;
                MailerData signData = new MailerData();
                signData.copy(data);
                signData.message = this.wrap(msgAndAddress.message);
                signData.encrypt = false;
                signData.encryptValidity = null;
                signData.signValidity = null;
                try {
                    this.processMessage(signData, msgAndAddress);
                    msgAndAddress.message = signData.message;
                }
                catch (Exception e) {
                    log.error("Error signing report email for email address \"" + msgAndAddress.address + "\". Error message: " + e.getMessage(), (Throwable)e);
                }
                break;
            }
            default: {
                throw new IllegalStateException("The given failure behavior (" + (Object)((Object)data.failureBehavior) + ") is not yet implemented.");
            }
        }
    }

    private void markEmailAsDoNotSend(MessageAndAddress msgAndAddress) {
        log.debug("Setting 'Do not send'-header for addressee: {}", (Object)msgAndAddress.address);
        try {
            msgAndAddress.message.addHeader("X-Do-Not-Send", Boolean.TRUE.toString());
        }
        catch (MessagingException e) {
            log.error("Could not set \"X-Do-Not-Send\"-header to email. Error message: " + e.getMessage(), (Throwable)e);
        }
        try {
            msgAndAddress.message.saveChanges();
        }
        catch (MessagingException e) {
            log.error("Could not save changes to email for " + msgAndAddress.address + ". Email might be corrupt. Error message: " + e.getMessage(), (Throwable)e);
        }
    }

    private MimeMessage wrap(MimeMessage msg) {
        try {
            return new SnotifyMimeMessage(this.getSession(), msg);
        }
        catch (MessagingException e) {
            log.error("Could not create copy of message. Error message: " + e.getMessage(), (Throwable)e);
            return msg;
        }
    }

    private void processMessage(MailerData data, MessageAndAddress orgMsgAndAddress) throws Exception {
        log.debug("Initial encryption data: {}", (Object)data);
        log.debug("Using type priority for encryption: {}", (Object)this.getTypePriority());
        switch (this.getTypePriority()) {
            case PGP_ONLY: {
                data.cryptography = ECryptographyType.PGP;
                this.processMessage(data);
                break;
            }
            case PGP_PREFERRED: {
                data.cryptography = ECryptographyType.PGP;
                this.processWithFallback(data, orgMsgAndAddress, ECryptographyType.SMIME);
                break;
            }
            case SMIME_ONLY: {
                data.cryptography = ECryptographyType.SMIME;
                this.processMessage(data);
                break;
            }
            case SMIME_PREFERRED: {
                data.cryptography = ECryptographyType.SMIME;
                this.processWithFallback(data, orgMsgAndAddress, ECryptographyType.PGP);
                break;
            }
            default: {
                throw new IllegalStateException("The given type priority (" + (Object)((Object)this.getTypePriority()) + ") is not yet implemented.");
            }
        }
        log.debug("Processed encryption data: {}", (Object)data);
    }

    private void processWithFallback(MailerData data, MessageAndAddress orgMsgAndAddress, ECryptographyType alternativeCryptography) throws Exception {
        Exception orgException = null;
        try {
            this.processMessage(data);
        }
        catch (Exception e) {
            log.debug("Error processing " + (Object)((Object)data.cryptography) + " cryptography. Error message: " + e.getMessage(), (Throwable)e);
            orgException = e;
        }
        if (orgException != null || data.encrypt && data.encryptValidity != EKeyValidity.VALID) {
            log.info("{} processing failed for {}. Using {} fallback processing.", new Object[]{data.cryptography, data.toAddress, alternativeCryptography});
            MailerData alternativeData = new MailerData();
            alternativeData.copy(data);
            alternativeData.message = this.wrap(orgMsgAndAddress.message);
            alternativeData.cryptography = alternativeCryptography;
            alternativeData.encryptValidity = null;
            alternativeData.signValidity = null;
            try {
                this.processMessage(alternativeData);
            }
            catch (Exception e) {
                log.debug("Error processing " + (Object)((Object)alternativeCryptography) + " cryptography. Error message: " + e.getMessage(), (Throwable)e);
                throw orgException != null ? orgException : e;
            }
            if (alternativeData.encryptValidity == EKeyValidity.VALID) {
                log.debug("Fallback {} encryption for \"{}\" successful.", (Object)alternativeCryptography, (Object)data.toAddress);
                data.copy(alternativeData);
            } else {
                log.info("Fallback {} encryption for \"{}\" not successful.", (Object)alternativeCryptography, (Object)data.toAddress);
            }
        }
    }

    private void processMessage(MailerData data) throws IOException, MessagingException {
        log.debug("Processing {} message for: \"{}\"", (Object)data.cryptography, (Object)data.toAddress);
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
            data.message.writeTo((OutputStream)debugBaos);
            log.trace("Email before processing:\n{}\n", (Object)debugBaos.toString());
        }
        String subjectReplacement = null;
        if (data.protect) {
            subjectReplacement = this.getSubjectReplacement(data.message);
        }
        if (data.protect) {
            log.debug("Starting protection of headers.");
            this.protect(data.message, data.cryptography);
            log.debug("Finished protection of headers.");
        }
        if (data.sign) {
            log.debug("Starting signing of message.");
            data.signValidity = this.sign(data.message, data.fromAddress, data.cryptography);
            log.debug("Finished signing of message.");
        }
        if (data.encrypt) {
            log.debug("Starting encryption of message.");
            data.encryptValidity = this.encrypt(data.message, data.fromAddress, data.toAddress, data.cryptography);
            log.debug("Finished encryption of message.");
        }
        if (this.isAdditionalSigning(data.cryptography) && data.sign && data.signValidity == EKeyValidity.VALID && data.encrypt && data.encryptValidity == EKeyValidity.VALID) {
            log.debug("Starting signing of message an additional time.");
            data.signValidity = this.sign(data.message, data.fromAddress, data.cryptography);
            log.debug("Finished signing of message an additional time.");
        }
        if (subjectReplacement != null && data.encryptValidity == EKeyValidity.VALID) {
            log.debug("Replacing subject with: {}", (Object)subjectReplacement);
            data.message.setSubject(subjectReplacement, "UTF-8");
            data.message.saveChanges();
        }
        log.debug("Finished processing {} message for: \"{}\"", (Object)data.cryptography, (Object)data.toAddress);
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
            data.message.writeTo((OutputStream)debugBaos);
            log.trace("Email after processing:\n{}\n", (Object)debugBaos.toString());
        }
    }

    private boolean isAdditionalSigning(ECryptographyType type) {
        switch (type) {
            case PGP: {
                return this.isAdditionalSigningPgp();
            }
            case SMIME: {
                return this.isAdditionalSigningSmime();
            }
        }
        log.debug("Unknown cryptography type given: {}", (Object)type);
        return false;
    }

    protected abstract EKeyValidity encrypt(MimeMessage var1, Address var2, Address var3, ECryptographyType var4) throws IOException, MessagingException;

    protected abstract EKeyValidity sign(MimeMessage var1, Address var2, ECryptographyType var3) throws IOException, MessagingException;

    protected abstract EKeyValidity protect(MimeMessage var1, ECryptographyType var2) throws IOException, MessagingException;

    protected abstract MimeMessage getFailureMessage(MessageAndAddress var1, EKeyValidity var2) throws MessagingException;

    protected boolean isEncryptionDesired(MessageAndAddress msgAndAddress) {
        return true;
    }

    protected boolean isSigningDesired(MessageAndAddress msgAndAddress) {
        return !this.isLiteMode();
    }

    protected boolean isProtectionDesired(MessageAndAddress msgAndAddress) {
        return !this.isLiteMode();
    }

    protected String getSubjectReplacement(MimeMessage msg) {
        return null;
    }

    protected EEncryptionFailureBehavior isEmailBlocked(Address address) {
        return EEncryptionFailureBehavior.ALLOW;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public String getVersion() {
        return this.getProductInformation().getVersion();
    }

    public boolean isDisabled() {
        if (this.disabled == null) {
            this.disabled = this.loadDisabled();
        }
        return this.disabled;
    }

    protected boolean loadDisabled() {
        return false;
    }

    public boolean isFrozen() {
        if (this.frozen == null) {
            this.frozen = this.loadFrozen();
        }
        return this.frozen;
    }

    protected boolean loadFrozen() {
        return false;
    }

    public boolean isLiteMode() {
        if (this.liteMode == null) {
            this.liteMode = this.loadLiteMode();
        }
        return this.liteMode;
    }

    protected boolean loadLiteMode() {
        return false;
    }

    public boolean isDryRun() {
        if (this.dryRun == null) {
            this.dryRun = this.loadDryRun();
        }
        return this.dryRun;
    }

    protected boolean loadDryRun() {
        return false;
    }

    public boolean isAdditionalSigningSmime() {
        if (this.additionalSigningSmime == null) {
            this.additionalSigningSmime = this.loadAdditionalSigningSmime();
        }
        return this.additionalSigningSmime;
    }

    protected boolean loadAdditionalSigningSmime() {
        return false;
    }

    public boolean isAdditionalSigningPgp() {
        if (this.additionalSigningPgp == null) {
            this.additionalSigningPgp = this.loadAdditionalSigningPgp();
        }
        return this.additionalSigningPgp;
    }

    protected boolean loadAdditionalSigningPgp() {
        return false;
    }

    public EEncryptionTypePriority getTypePriority() {
        if (this.typePriority == null) {
            this.typePriority = this.loadTypePriority();
        }
        return this.typePriority;
    }

    protected EEncryptionTypePriority loadTypePriority() {
        return EEncryptionTypePriority.SMIME_PREFERRED;
    }

    public EEncryptionFailureBehavior getFailureBehavior() {
        if (this.failureBehavior == null) {
            this.failureBehavior = this.loadFailureBehavior();
        }
        return this.failureBehavior;
    }

    protected EEncryptionFailureBehavior loadFailureBehavior() {
        return EEncryptionFailureBehavior.ALLOW;
    }

    public ProductInformation getProductInformation() {
        if (this.productInformation == null) {
            this.productInformation = this.loadProductInformation();
        }
        return this.productInformation;
    }

    protected ProductInformation loadProductInformation() {
        ProductInformation info = new ProductInformation();
        info.setHost(ProductInformation.loadHostName());
        info.setProduct("Savignano");
        info.setVersion(ProductInformation.loadVersion());
        return info;
    }

    private static final class MailerData {
        public MimeMessage message;
        public Address toAddress;
        public Address fromAddress;
        public ECryptographyType cryptography;
        public boolean encrypt;
        public boolean sign;
        public boolean protect;
        public EKeyValidity encryptValidity;
        public EKeyValidity signValidity;
        public EEncryptionFailureBehavior failureBehavior;
        public boolean send;

        private MailerData() {
        }

        public void copy(MailerData data) {
            this.message = data.message;
            this.toAddress = data.toAddress;
            this.fromAddress = data.fromAddress;
            this.cryptography = data.cryptography;
            this.encrypt = data.encrypt;
            this.sign = data.sign;
            this.protect = data.protect;
            this.encryptValidity = data.encryptValidity;
            this.signValidity = data.signValidity;
            this.failureBehavior = data.failureBehavior;
            this.send = data.send;
        }

        public String toString() {
            return "EncryptionData [toAddress=" + this.toAddress + ", fromAddress=" + this.fromAddress + ", cryptography=" + (Object)((Object)this.cryptography) + ", encrypt=" + this.encrypt + ", sign=" + this.sign + ", protect=" + this.protect + ", encryptValidity=" + (Object)((Object)this.encryptValidity) + ", signValidity=" + (Object)((Object)this.signValidity) + ",failureBehavior=" + (Object)((Object)this.failureBehavior) + ", send=" + this.send + "]";
        }
    }
}

