/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import java.net.URL;
import net.savignano.snotify.atlassian.mailer.AAtlassianMailKeyExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraMailIssueExtractor
extends AAtlassianMailKeyExtractor {
    private static final Logger log = LoggerFactory.getLogger(JiraMailIssueExtractor.class);
    private IssueManager issueManager;

    public JiraMailIssueExtractor(String baseUrl) {
        super(baseUrl);
    }

    @Override
    protected String getKey(URL url) {
        String path = url.getPath();
        if (path.contains("/browse/")) {
            return this.transformToIssueKey(path.substring(path.lastIndexOf(47) + 1));
        }
        if (path.contains("/servicedesk/customer/portal/")) {
            return this.transformToIssueKey(path.substring(path.lastIndexOf(47) + 1));
        }
        return null;
    }

    private String transformToIssueKey(String match) {
        MutableIssue issue = this.getIssueManager().getIssueByCurrentKey(match);
        if (issue != null) {
            log.debug("Match {} is an issue.", (Object)match);
            return match;
        }
        log.debug("Match {} is not an issue.", (Object)match);
        return null;
    }

    private IssueManager getIssueManager() {
        if (this.issueManager == null) {
            this.issueManager = ComponentAccessor.getIssueManager();
        }
        return this.issueManager;
    }
}

