/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer;

import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.mail.Session;
import net.savignano.cryptography.key.IPublicCryptographyKey;
import net.savignano.snotify.jira.mailer.decorator.DecoratorData;
import net.savignano.snotify.jira.mailer.decrypt.AComposedMailDecryptor;
import net.savignano.snotify.jira.mailer.validate.ComposedMailValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageStoreTransformerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MessageStoreTransformerConfiguration.class);
    private final Function<Session, AComposedMailDecryptor> decryptorFunction;
    private final Function<Session, ComposedMailValidator> validatorFunction;
    private BiConsumer<IPublicCryptographyKey<?>, String> publicKeyConsumer;
    private DecoratorData decoData;
    private boolean disabled;
    private boolean frozen;
    private boolean lite;
    private boolean removeSignature = true;
    private boolean extractPublicKey;
    private boolean checkOnlySignature;
    private boolean checkPgpInline;
    private boolean treatDecryptionWarningAsFailure;
    private String pgpBinaryAttachmentRegex;

    public MessageStoreTransformerConfiguration(Function<Session, AComposedMailDecryptor> decryptorFunction, Function<Session, ComposedMailValidator> validatorFunction) {
        if (decryptorFunction == null) {
            log.warn("No decryption function given. Mail decryption cannot happen.");
            this.decryptorFunction = s -> null;
        } else {
            this.decryptorFunction = decryptorFunction;
        }
        if (validatorFunction == null) {
            log.warn("No validator function given. Mail validation cannot happen.");
            this.validatorFunction = s -> null;
        } else {
            this.validatorFunction = validatorFunction;
        }
    }

    public Function<Session, AComposedMailDecryptor> getDecryptorFunction() {
        return this.decryptorFunction;
    }

    public Function<Session, ComposedMailValidator> getValidatorFunction() {
        return this.validatorFunction;
    }

    public BiConsumer<IPublicCryptographyKey<?>, String> getPublicKeyConsumer() {
        return this.publicKeyConsumer;
    }

    public void setPublicKeyConsumer(BiConsumer<IPublicCryptographyKey<?>, String> publicKeyConsumer) {
        this.publicKeyConsumer = publicKeyConsumer;
    }

    public DecoratorData getDecoratorData() {
        return this.decoData;
    }

    public void setDecoratorData(DecoratorData data) {
        this.decoData = data;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public boolean isLite() {
        return this.lite;
    }

    public void setLite(boolean lite) {
        this.lite = lite;
    }

    public boolean isRemoveSignature() {
        return this.removeSignature;
    }

    public void setRemoveSignature(boolean removeSignature) {
        this.removeSignature = removeSignature;
    }

    public boolean isExtractPublicKey() {
        return this.extractPublicKey;
    }

    public void setExtractPublicKey(boolean extractPublicKey) {
        this.extractPublicKey = extractPublicKey;
    }

    public boolean isCheckOnlySignature() {
        return this.checkOnlySignature;
    }

    public void setCheckOnlySignature(boolean checkOnlySignature) {
        this.checkOnlySignature = checkOnlySignature;
    }

    public boolean isCheckPgpInline() {
        return this.checkPgpInline;
    }

    public void setCheckPgpInline(boolean checkPgpInline) {
        this.checkPgpInline = checkPgpInline;
    }

    public String getPgpBinaryAttachmentRegex() {
        return this.pgpBinaryAttachmentRegex;
    }

    public void setPgpBinaryAttachmentRegex(String pgpBinaryAttachmentRegex) {
        this.pgpBinaryAttachmentRegex = pgpBinaryAttachmentRegex;
    }

    public boolean isTreatDecryptionWarningAsFailure() {
        return this.treatDecryptionWarningAsFailure;
    }

    public void setTreatDecryptionWarningAsFailure(boolean treatDecryptionWarningAsFailure) {
        this.treatDecryptionWarningAsFailure = treatDecryptionWarningAsFailure;
    }

    public String toString() {
        return "MessageStoreTransformerConfiguration [decryptorFunction=" + this.decryptorFunction + ", validatorFunction=" + this.validatorFunction + ", publicKeyConsumer=" + this.publicKeyConsumer + ", decoData=" + this.decoData + ", disabled=" + this.disabled + ", frozen=" + this.frozen + ", lite=" + this.lite + ", removeSignature=" + this.removeSignature + ", extractPublicKey=" + this.extractPublicKey + ", checkOnlySignature=" + this.checkOnlySignature + ", checkPgpInline=" + this.checkPgpInline + ", pgpBinaryAttachmentRegex=" + this.pgpBinaryAttachmentRegex + ", treatDecryptionWarningAsFailure=" + this.treatDecryptionWarningAsFailure + "]";
    }
}

