/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer.decorator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.snotify.jira.mailer.decorator.ITicketDecoration;

public class MessageDecorator {
    private final List<ITicketDecoration> decorations = new ArrayList<ITicketDecoration>(5);

    public List<ITicketDecoration> getDecorations() {
        return this.decorations;
    }

    public void apply(MimeMessage msg) throws MessagingException, IOException {
        if (this.getDecorations().isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder(500);
        builder.append("{panel:bgColor=#f8f8f8|borderColor=#f0f0f0}{color:gray}");
        for (ITicketDecoration decoration : this.getDecorations()) {
            builder.append(decoration.getDecoration());
            builder.append(' ');
        }
        builder.append("{color}{panel}\n\n");
        MimeBodyPart part1 = new MimeBodyPart();
        part1.setText(builder.toString(), "UTF-8");
        part1.setDescription("Security Status as Markup.");
        MimeBodyPart part2 = new MimeBodyPart();
        MessageUtil.movePart((Part)msg, (Part)part2);
        part2.setDescription("Actual Content from Message.");
        MimeMultipart multi = new MimeMultipart();
        multi.addBodyPart((BodyPart)part1);
        multi.addBodyPart((BodyPart)part2);
        msg.setContent((Multipart)multi);
        msg.setDisposition(null);
        msg.saveChanges();
    }
}

