/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer.decorator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.jira.mailer.decorator.DecoratorData;
import net.savignano.snotify.jira.mailer.decorator.EIconDecorator;
import net.savignano.snotify.jira.mailer.decorator.ITicketDecoration;
import net.savignano.snotify.jira.mailer.decorator.ImageDecoration;
import net.savignano.snotify.jira.mailer.decorator.MessageDecorator;

public class MessageDecoratorHelper {
    private final DecoratorData data;
    private final MessageDecorator decorator;
    private int signedIndex = -1;
    private EIconDecorator signedIcon;
    private final List<EIconDecorator> priorityList;

    private static final List<EIconDecorator> createPriorityList() {
        ArrayList<EIconDecorator> priority = new ArrayList<EIconDecorator>(6);
        priority.add(EIconDecorator.SIGNED_MISMATCH);
        priority.add(EIconDecorator.SIGNED_UNVERIFIED);
        priority.add(EIconDecorator.SIGNED_VERIFIED);
        priority.add(EIconDecorator.SIGNED);
        priority.add(EIconDecorator.SIGNED_UNKNOWN);
        priority.add(EIconDecorator.UNSIGNED);
        return priority;
    }

    public MessageDecoratorHelper(DecoratorData data) {
        this.data = data;
        this.decorator = new MessageDecorator();
        this.priorityList = MessageDecoratorHelper.createPriorityList();
    }

    public void clear() {
        this.signedIndex = -1;
        this.signedIcon = null;
        this.decorator.getDecorations().clear();
    }

    public void apply(MimeMessage msg) throws MessagingException, IOException {
        this.decorator.apply(msg);
    }

    public void add(ITicketDecoration deco) {
        if (deco == null) {
            return;
        }
        this.decorator.getDecorations().add(deco);
    }

    public void add(EIconDecorator icon) {
        if (icon == null) {
            return;
        }
        ITicketDecoration signedDeco = null;
        if (this.signedIndex != -1) {
            signedDeco = this.decorator.getDecorations().remove(this.signedIndex);
            this.signedIndex = -1;
        }
        if (this.data.displayMissingProtection || !this.isMissing(icon)) {
            ImageDecoration deco = icon.getDecoration(this.data.baseUrl, this.data.guiKey);
            if (this.isSignedIcon(icon)) {
                if (this.updateSignedIcon(icon)) {
                    signedDeco = deco;
                    this.signedIcon = icon;
                }
            } else {
                this.add(deco);
            }
        }
        if (signedDeco != null && (icon != EIconDecorator.ENCRYPTED_UNKNOWN || this.signedIcon != EIconDecorator.UNSIGNED)) {
            this.signedIndex = this.decorator.getDecorations().size();
            this.add(signedDeco);
        }
    }

    private boolean updateSignedIcon(EIconDecorator newIcon) {
        if (this.signedIcon == null) {
            return true;
        }
        return this.priorityList.indexOf((Object)newIcon) < this.priorityList.indexOf((Object)this.signedIcon);
    }

    private boolean isMissing(EIconDecorator icon) {
        switch (icon) {
            case UNENCRYPTED: 
            case UNSIGNED: {
                return true;
            }
        }
        return false;
    }

    private boolean isSignedIcon(EIconDecorator icon) {
        switch (icon) {
            case UNSIGNED: 
            case SIGNED: 
            case SIGNED_MISMATCH: 
            case SIGNED_UNKNOWN: 
            case SIGNED_UNVERIFIED: 
            case SIGNED_VERIFIED: {
                return true;
            }
        }
        return false;
    }
}

