/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer.imap;

import com.sun.mail.imap.IMAPMessage;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.jira.mailer.MessageStoreTransformer;
import net.savignano.snotify.jira.mailer.MessageStoreTransformerConfiguration;
import net.savignano.snotify.jira.mailer.imap.SnotifyImapMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImapMessageTransformer
extends MessageStoreTransformer<IMAPMessage> {
    private static final Logger log = LoggerFactory.getLogger(ImapMessageTransformer.class);

    public ImapMessageTransformer(MessageStoreTransformerConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected boolean sanityCheckMessage(Message orgMsg) {
        if (!super.sanityCheckMessage(orgMsg)) {
            return false;
        }
        if (orgMsg instanceof SnotifyImapMessage) {
            log.debug("Message with number {} is an SnotifyImapMessage. Do not need to transform, as this has already happened.", (Object)orgMsg.getMessageNumber());
            return false;
        }
        if (!(orgMsg instanceof IMAPMessage)) {
            log.warn("Sanity check failed. Message with message number {} is not an IMAPMessage. Encountered class: {}", (Object)orgMsg.getMessageNumber(), orgMsg.getClass());
            return false;
        }
        return true;
    }

    @Override
    protected MimeMessage loadMessage(IMAPMessage orgMsg) throws MessagingException {
        orgMsg.setPeek(true);
        return super.loadMessage(orgMsg);
    }

    @Override
    protected MimeMessage wrap(MimeMessage processedMsg, IMAPMessage orgMsg) throws MessagingException {
        return new SnotifyImapMessage(processedMsg.getSession(), processedMsg, orgMsg);
    }

    @Override
    public Message unwrap(Message msg) throws MessagingException {
        if (msg == null) {
            log.warn("Cannot convert to IMAP message, null parameter received.");
            return null;
        }
        log.debug("Message with message number {} is of type: {}", (Object)msg.getMessageNumber(), (Object)msg.getClass().getSimpleName());
        if (msg instanceof SnotifyImapMessage) {
            return ((SnotifyImapMessage)msg).getImapMessage();
        }
        if (msg instanceof IMAPMessage) {
            return msg;
        }
        log.error("Message with message number {} is not an IMAPMessage, but: {}", (Object)msg.getMessageNumber(), (Object)msg.getClass().getName());
        throw new MessagingException("Message with message number " + msg.getMessageNumber() + " is not an IMAPMessage, but: " + msg.getClass().getName());
    }
}

