/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer.imap;

import com.sun.mail.imap.IMAPStore;
import com.sun.mail.imap.SortTerm;
import com.sun.mail.imap.protocol.ListInfo;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.search.SearchTerm;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.properties.ISnotifyUserProperties;
import net.savignano.snotify.jira.mailer.AtlassianIncomingMailHandler;
import net.savignano.snotify.jira.mailer.imap.ASnotifyImapFolder;
import net.savignano.snotify.jira.mailer.imap.ImapMessageTransformer;
import net.savignano.snotify.jira.mailer.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyImapFolder
extends ASnotifyImapFolder {
    private static final Logger log = LoggerFactory.getLogger(SnotifyImapFolder.class);

    public SnotifyImapFolder(ListInfo li, IMAPStore store) {
        super(li, store);
        log.debug("Using S/Notify IMAP folder implementation to receive emails.");
    }

    public SnotifyImapFolder(String fullName, char separator, IMAPStore store, Boolean isNamespace) {
        super(fullName, separator, store, isNamespace);
        log.debug("Using S/Notify IMAP folder implementation to receive emails.");
    }

    @Override
    public synchronized Message getMessageByUID(long uid) throws MessagingException {
        Message msg = super.getMessageByUID(uid);
        this.expungeDoNotSend(msg);
        return msg;
    }

    @Override
    public synchronized Message[] getMessagesByUID(long start, long end) throws MessagingException {
        Message[] msgs = super.getMessagesByUID(start, end);
        this.expungeDoNotSend(msgs);
        return msgs;
    }

    @Override
    public synchronized Message[] getMessagesByUID(long[] uids) throws MessagingException {
        Message[] msgs = super.getMessagesByUID(uids);
        this.expungeDoNotSend(msgs);
        return msgs;
    }

    @Override
    public synchronized Message getMessage(int msgnum) throws MessagingException {
        Message msg = super.getMessage(msgnum);
        this.expungeDoNotSend(msg);
        return msg;
    }

    @Override
    public synchronized Message[] getMessages() throws MessagingException {
        Message[] msgs = super.getMessages();
        this.expungeDoNotSend(msgs);
        return msgs;
    }

    @Override
    public synchronized Message[] getSortedMessages(SortTerm[] term, SearchTerm sterm) throws MessagingException {
        Message[] msgs = super.getSortedMessages(term, sterm);
        this.expungeDoNotSend(msgs);
        return msgs;
    }

    @Override
    public synchronized Message[] search(SearchTerm term) throws MessagingException {
        Message[] msgs = super.search(term);
        this.expungeDoNotSend(msgs);
        return msgs;
    }

    @Override
    public synchronized Message[] search(SearchTerm term, Message[] msgs) throws MessagingException {
        Message[] messages = super.search(term, msgs);
        this.expungeDoNotSend(messages);
        return messages;
    }

    private void expungeDoNotSend(Message ... msgs) throws MessagingException {
        if (msgs == null || this.mode != 2) {
            return;
        }
        for (Message msg : msgs) {
            String[] header;
            if (msg == null || (header = msg.getHeader("X-Do-Not-Send")) == null || header.length == 0 || !Boolean.parseBoolean(header[0])) continue;
            log.info("Message with ID {} has a 'do not send'-header of S/Notify. This message should not be here and will be deleted.", (Object)MessageUtil.getMessageId(msg));
            msg.setFlag(Flags.Flag.DELETED, true);
        }
    }

    @Override
    protected ImapMessageTransformer createMessageTransformer() {
        ISnotifyAppProperties appProps = this.getAppProps();
        AtlassianIncomingMailHandler handler = new AtlassianIncomingMailHandler(appProps, this.getUserProps());
        return new ImapMessageTransformer(handler.createConfiguration());
    }

    private ISnotifyAppProperties getAppProps() {
        return PropertiesUtil.getAppProps();
    }

    private ISnotifyUserProperties getUserProps() {
        return PropertiesUtil.getUserProps();
    }
}

