/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer.imap;

import com.sun.mail.imap.IMAPSSLStore;
import javax.mail.Session;
import javax.mail.URLName;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.snotify.jira.mailer.imap.SnotifyImapFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyImapsStore
extends IMAPSSLStore {
    private static final Logger log = LoggerFactory.getLogger(SnotifyImapsStore.class);

    private static final Session addFolderProperty(Session session) {
        if (SecurityUtil.checkSelfIntegrity()) {
            session.getProperties().put("mail.imaps.folder.class", SnotifyImapFolder.class.getName());
        } else {
            log.error("Signature of S/Notify is not correct. To protect underlying system, S/Notify will be disabled, as it has been tampered with.");
        }
        return session;
    }

    public SnotifyImapsStore(Session session, URLName url) {
        super(SnotifyImapsStore.addFolderProperty(session), url);
        log.debug("Using S/Notify IMAP SSL store implementation to receive emails.");
        log.trace("Session properties used: {}", (Object)session.getProperties());
        SecurityUtil.getProvider();
    }
}

