/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer.keysource.smime;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.naming.ConfigurationException;
import net.savignano.cryptography.connector.LdapConnector;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.loader.IKeyLoader;
import net.savignano.cryptography.key.loader.smime.SmimeLdapLoader;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.connector.AtlassianLdapConnector;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.properties.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.user.IUser;
import net.savignano.snotify.atlassian.mailer.keysource.smime.SmimePublicKeyManager;
import net.savignano.snotify.jira.common.JiraUser;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraSmimeKeyManager
extends SmimePublicKeyManager {
    private static final Logger log = LoggerFactory.getLogger(JiraSmimeKeyManager.class);

    public JiraSmimeKeyManager(ISnotifyAppProperties appProps, ISnotifyUserProperties userProps) {
        super(appProps, userProps);
    }

    @Override
    protected List<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<SmimeEncryptionKey, IUser<?>>>>>> getKeyLoaders() {
        List<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<SmimeEncryptionKey, IUser<?>>>>>> loaders = super.getKeyLoaders();
        loaders.add(new AbstractMap.SimpleEntry<EKeySource, Supplier<Optional>>(EKeySource.ATLASSIAN_DIRECTORY, this::createAtlassianDirectoryLoader));
        return loaders;
    }

    private Optional<IKeyLoader<SmimeEncryptionKey, IUser<?>>> createAtlassianDirectoryLoader() {
        if (!this.getAppProps().getBoolean(EProperty.USER_DIRECTORY_LDAP_QUERY_SMIME)) {
            log.debug("Retrieving certificate from LDAP server is disabled.");
            return Optional.empty();
        }
        IKeyLoader keyLoader = new IKeyLoader<SmimeEncryptionKey, IUser<?>>(){

            @Override
            public SmimeEncryptionKey loadKey(IUser<?> user) {
                ApplicationUser appUser = JiraSmimeKeyManager.this.getApplicationUser(user);
                AtlassianLdapConnector connector = JiraSmimeKeyManager.this.getLdapConnector(appUser);
                if (connector == null) {
                    return JiraSmimeKeyManager.this.getValidityKey(EKeyValidity.NOT_FOUND, this.getKeySource());
                }
                String userFilter = "(" + connector.getUserNameKey() + "=" + appUser.getDirectoryUser().getName() + ")";
                return (SmimeEncryptionKey)JiraSmimeKeyManager.this.getLdapLoader(connector).loadKey((Pair<String, String>)Pair.of((Object)userFilter, (Object)appUser.getEmailAddress()));
            }

            @Override
            public EKeySource getKeySource() {
                return EKeySource.ATLASSIAN_DIRECTORY;
            }

            @Override
            public ECryptographyType getCryptography() {
                return ECryptographyType.SMIME;
            }
        };
        return Optional.of(keyLoader);
    }

    private SmimeLdapLoader getLdapLoader(LdapConnector connector) {
        SmimeLdapLoader loader = new SmimeLdapLoader(connector);
        loader.setKeySource(EKeySource.ATLASSIAN_DIRECTORY);
        loader.setExpectP7b(this.getAppProps().getBoolean(EProperty.TWEAK_EXPECT_P7B_IN_LDAP));
        return loader;
    }

    private AtlassianLdapConnector getLdapConnector(ApplicationUser user) {
        Directory directory;
        if (user == null) {
            log.debug("Not an application user.");
            return null;
        }
        long directoryId = user.getDirectoryId();
        DirectoryManager manager = (DirectoryManager)ComponentAccessor.getComponent(DirectoryManager.class);
        try {
            directory = manager.findDirectoryById(directoryId);
        }
        catch (DirectoryNotFoundException e) {
            log.error("Could not find directory with ID " + directoryId + ". Error message: " + e.getMessage(), (Throwable)e);
            return null;
        }
        if (!AtlassianLdapConnector.isConnector(directory)) {
            log.debug("Directory {} is not connecting to an LDAP.", (Object)directory.getName());
            return null;
        }
        try {
            AtlassianLdapConnector connector = AtlassianLdapConnector.createConnector(directory);
            connector.setDisableTrustCheck(connector.isDisableTrustCheck() && this.getAppProps().getBoolean(EProperty.TWEAK_USER_DIRECTORY_INSECURE));
            return connector;
        }
        catch (ConfigurationException e) {
            log.error("Could not create an LDAP from directory " + directory.getName() + ". Error message: " + e.getMessage());
            return null;
        }
    }

    private ApplicationUser getApplicationUser(IUser<?> user) {
        if (user != null && user instanceof JiraUser) {
            return (ApplicationUser)user.getActualUser();
        }
        return null;
    }
}

