/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer.pop3;

import com.sun.mail.pop3.POP3Message;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.jira.mailer.MessageStoreTransformer;
import net.savignano.snotify.jira.mailer.MessageStoreTransformerConfiguration;
import net.savignano.snotify.jira.mailer.pop3.SnotifyPop3Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pop3MessageTransformer
extends MessageStoreTransformer<POP3Message> {
    private static final Logger log = LoggerFactory.getLogger(Pop3MessageTransformer.class);

    public Pop3MessageTransformer(MessageStoreTransformerConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected boolean sanityCheckMessage(Message orgMsg) {
        if (!super.sanityCheckMessage(orgMsg)) {
            return false;
        }
        if (orgMsg instanceof SnotifyPop3Message) {
            log.debug("Message with number {} is an SnotifyPop3Message. Do not need to transform, as this has already happened.", (Object)orgMsg.getMessageNumber());
            return false;
        }
        if (!(orgMsg instanceof POP3Message)) {
            log.warn("Sanity check failed. Message with message number {} is not an POP3Message. Encountered class: {}", (Object)orgMsg.getMessageNumber(), orgMsg.getClass());
            return false;
        }
        return true;
    }

    @Override
    protected MimeMessage wrap(MimeMessage processedMsg, POP3Message orgMsg) throws MessagingException {
        return new SnotifyPop3Message(processedMsg.getSession(), processedMsg, orgMsg);
    }

    @Override
    public Message unwrap(Message msg) throws MessagingException {
        if (msg == null) {
            log.warn("Cannot convert to POP3 message, null parameter received.");
            return null;
        }
        log.debug("Message with message number {} is of type: {}", (Object)msg.getMessageNumber(), (Object)msg.getClass().getSimpleName());
        if (msg instanceof SnotifyPop3Message) {
            return ((SnotifyPop3Message)msg).getPop3Message();
        }
        if (msg instanceof POP3Message) {
            return msg;
        }
        log.error("Message with message number {} is not a POP3Message, but: {}", (Object)msg.getMessageNumber(), (Object)msg.getClass().getName());
        throw new MessagingException("Message with message number " + msg.getMessageNumber() + " is not a POP3Message, but: " + msg.getClass().getName());
    }
}

