/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer.pop3;

import com.sun.mail.pop3.POP3Store;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.URLName;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.snotify.jira.mailer.pop3.SnotifyPop3Folder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyPop3Store
extends POP3Store {
    private static final Logger log = LoggerFactory.getLogger(SnotifyPop3Store.class);

    public SnotifyPop3Store(Session session, URLName url) {
        super(session, url);
        log.debug("Using S/Notify POP3 Store implementation to receive emails.");
        log.trace("Session properties used: {}", (Object)session.getProperties());
        SecurityUtil.getProvider();
    }

    public Folder getFolder(String name) throws MessagingException {
        if (!SecurityUtil.checkSelfIntegrity()) {
            log.error("Signature of S/Notify is not correct. To protect underlying system, S/Notify will be disabled, as it has been tampered with.");
            return super.getFolder(name);
        }
        this.checkConnected();
        return new SnotifyPop3Folder(this, name);
    }

    public Folder getFolder(URLName url) throws MessagingException {
        if (!SecurityUtil.checkSelfIntegrity()) {
            log.error("Signature of S/Notify is not correct. To protect underlying system, S/Notify will be disabled, as it has been tampered with.");
            return super.getFolder(url);
        }
        this.checkConnected();
        return new SnotifyPop3Folder(this, url.getFile());
    }

    private void checkConnected() throws MessagingException {
        if (!this.isConnected()) {
            throw new MessagingException("Not connected.");
        }
    }
}

