/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer.validate;

import java.util.function.Supplier;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyPurpose;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.ACryptographyKey;
import net.savignano.cryptography.key.IPublicCryptographyKey;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;
import net.savignano.cryptography.mail.validate.IMailValidator;
import net.savignano.cryptography.mail.validate.PgpMailValidator;
import net.savignano.cryptography.mail.validate.SmimeMailValidator;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.snotify.jira.mailer.validate.IComposedMailValidator;
import net.savignano.snotify.jira.mailer.validate.ValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComposedMailValidator
implements IComposedMailValidator {
    private static final Logger log = LoggerFactory.getLogger(ComposedMailValidator.class);
    private IMailValidator<PgpEncryptionKey> pgpValidator;
    private IMailValidator<SmimeEncryptionKey> smimeValidator;
    private Supplier<IMailValidator<PgpEncryptionKey>> pgpValidatorSupplier;
    private Supplier<IMailValidator<SmimeEncryptionKey>> smimeValidatorSupplier;
    private boolean checkPgpInline;

    @Override
    public ValidationResult validate(MimeMessage msg) {
        String msgId;
        ValidationResult result = new ValidationResult(msg);
        try {
            msgId = msg.getMessageID();
        }
        catch (MessagingException e) {
            log.error(e.getMessage(), (Throwable)e);
            msgId = "N/A";
        }
        IMailValidator<ACryptographyKey> validator = null;
        if (SmimeMailValidator.isMessageSigned((Message)msg)) {
            log.debug("Message {} is S/MIME signed.", (Object)msgId);
            validator = this.getSmimeValidator();
        } else if (PgpMailValidator.isMessageSigned((Message)msg) || this.isCheckPgpInline() && PgpMailValidator.isMessageSignedInline((Message)msg)) {
            log.debug("Message {} is PGP signed.", (Object)msgId);
            validator = this.getPgpValidator();
        } else {
            log.debug("Message {} is not signed.", (Object)msgId);
        }
        if (validator != null) {
            result.setCryptography(validator.getCryptography());
            result.getPossibleValidations().addAll(validator.getValidationCapability());
            try {
                result.getValidations().addAll(validator.validate(msg));
            }
            catch (Exception e) {
                result.setError(e);
            }
        }
        return result;
    }

    @Override
    public IPublicCryptographyKey<?> extractPublicKey(MimeMessage msg) {
        String msgId = MessageUtil.getMessageId((Message)msg);
        if (SmimeMailValidator.isMessageSigned((Message)msg)) {
            log.debug("Message {} is S/MIME signed.", (Object)msgId);
            return this.extractSmimeKey(msg);
        }
        if (PgpMailValidator.isMessageSigned((Message)msg)) {
            log.debug("Message {} is PGP signed.", (Object)msgId);
            return this.extractPgpKey(msg);
        }
        log.debug("Message {} is not signed.", (Object)msgId);
        return new NotFoundKey();
    }

    private PgpEncryptionKey extractPgpKey(MimeMessage msg) {
        IMailValidator<PgpEncryptionKey> validator = this.getPgpValidator();
        if (validator != null) {
            return validator.extractPublicKey(msg);
        }
        return new PgpEncryptionKey(EKeyValidity.NOT_FOUND, EKeySource.EMAIL);
    }

    private SmimeEncryptionKey extractSmimeKey(MimeMessage msg) {
        IMailValidator<SmimeEncryptionKey> validator = this.getSmimeValidator();
        if (validator != null) {
            return validator.extractPublicKey(msg);
        }
        return new SmimeEncryptionKey(EKeyValidity.NOT_FOUND, EKeySource.EMAIL);
    }

    @Override
    public boolean isSigned(MimeMessage message) {
        return SmimeMailValidator.isMessageSigned((Message)message) || PgpMailValidator.isMessageSigned((Message)message) || this.isCheckPgpInline() && PgpMailValidator.isMessageSignedInline((Message)message);
    }

    public IMailValidator<PgpEncryptionKey> getPgpValidator() {
        if (this.pgpValidator == null && this.pgpValidatorSupplier != null) {
            this.pgpValidator = this.pgpValidatorSupplier.get();
        }
        return this.pgpValidator;
    }

    public void setPgpValidator(IMailValidator<PgpEncryptionKey> validator) {
        this.pgpValidator = validator;
    }

    public void setPgpValidatorSupplier(Supplier<IMailValidator<PgpEncryptionKey>> supplier) {
        this.pgpValidatorSupplier = supplier;
    }

    public IMailValidator<SmimeEncryptionKey> getSmimeValidator() {
        if (this.smimeValidator == null && this.smimeValidatorSupplier != null) {
            this.smimeValidator = this.smimeValidatorSupplier.get();
        }
        return this.smimeValidator;
    }

    public void setSmimeValidator(IMailValidator<SmimeEncryptionKey> validator) {
        this.smimeValidator = validator;
    }

    public void setSmimeValidatorSupplier(Supplier<IMailValidator<SmimeEncryptionKey>> supplier) {
        this.smimeValidatorSupplier = supplier;
    }

    public boolean isCheckPgpInline() {
        return this.checkPgpInline;
    }

    public void setCheckPgpInline(boolean checkPgpInline) {
        this.checkPgpInline = checkPgpInline;
    }

    private static class NotFoundKey
    extends ACryptographyKey<Object>
    implements IPublicCryptographyKey<Object> {
        public NotFoundKey() {
            super(EKeyPurpose.ENCRYPTION, ECryptographyType.NONE);
            this.setKeyValidity(EKeyValidity.NOT_FOUND);
            this.setKeySource(EKeySource.EMAIL);
        }

        @Override
        public Object getKey() {
            return null;
        }
    }
}

