/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer.validate;

import java.util.EnumSet;
import java.util.Set;
import javax.mail.Message;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EValidationType;
import net.savignano.cryptography.util.MessageUtil;

public class ValidationResult {
    private final MimeMessage msg;
    private ECryptographyType cryptoType = ECryptographyType.NONE;
    private Exception error;
    private final Set<EValidationType> validations = EnumSet.noneOf(EValidationType.class);
    private final Set<EValidationType> possibleValidations = EnumSet.noneOf(EValidationType.class);

    public ValidationResult(MimeMessage msg) {
        this.msg = msg;
    }

    public boolean isValid() {
        return this.getValidations().equals(this.getPossibleValidations()) && this.getCryptography() != ECryptographyType.NONE && this.getError() == null;
    }

    public MimeMessage getMessage() {
        return this.msg;
    }

    public ECryptographyType getCryptography() {
        return this.cryptoType;
    }

    public void setCryptography(ECryptographyType cryptoType) {
        this.cryptoType = cryptoType;
    }

    public Exception getError() {
        return this.error;
    }

    public void setError(Exception error) {
        this.error = error;
    }

    public Set<EValidationType> getValidations() {
        return this.validations;
    }

    public Set<EValidationType> getPossibleValidations() {
        return this.possibleValidations;
    }

    public String toString() {
        return "ValidationResult [isValid()=" + this.isValid() + ", cryptoType=" + (Object)((Object)this.cryptoType) + ", error=" + this.error + ", validations=" + this.validations + ", possibleValidations=" + this.possibleValidations + ", msgId=" + MessageUtil.getMessageId((Message)this.msg) + "]";
    }
}

