/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.crypto.tls;

import java.math.BigInteger;
import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoServicePurpose;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.savignano.thirdparty.org.bouncycastle.crypto.DataLengthException;
import net.savignano.thirdparty.org.bouncycastle.crypto.constraints.ConstraintUtils;
import net.savignano.thirdparty.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.RSAKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.BigIntegers;
import net.savignano.thirdparty.org.bouncycastle.util.Pack;

public abstract class TlsRsaKeyExchange {
    public static final int PRE_MASTER_SECRET_LENGTH = 48;
    private static final BigInteger ONE = BigInteger.valueOf(1L);

    private TlsRsaKeyExchange() {
    }

    public static byte[] decryptPreMasterSecret(byte[] in, int inOff, int inLen, RSAKeyParameters privateKey, int protocolVersion, SecureRandom secureRandom) {
        if (in == null || inLen < 1 || inLen > TlsRsaKeyExchange.getInputLimit(privateKey) || inOff < 0 || inOff > in.length - inLen) {
            throw new IllegalArgumentException("input not a valid EncryptedPreMasterSecret");
        }
        if (!privateKey.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be an RSA private key");
        }
        BigInteger modulus = privateKey.getModulus();
        int bitLength = modulus.bitLength();
        if (bitLength < 512) {
            throw new IllegalArgumentException("'privateKey' must be at least 512 bits");
        }
        int bitsOfSecurity = ConstraintUtils.bitsOfSecurityFor(modulus);
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("RSA", bitsOfSecurity, privateKey, CryptoServicePurpose.DECRYPTION));
        if ((protocolVersion & 0xFFFF) != protocolVersion) {
            throw new IllegalArgumentException("'protocolVersion' must be a 16 bit value");
        }
        secureRandom = CryptoServicesRegistrar.getSecureRandom(secureRandom);
        byte[] result = new byte[48];
        secureRandom.nextBytes(result);
        try {
            BigInteger input = TlsRsaKeyExchange.convertInput(modulus, in, inOff, inLen);
            byte[] encoding = TlsRsaKeyExchange.rsaBlinded(privateKey, input, secureRandom);
            int pkcs1Length = (bitLength - 1) / 8;
            int plainTextOffset = encoding.length - 48;
            int badEncodingMask = TlsRsaKeyExchange.checkPkcs1Encoding2(encoding, pkcs1Length, 48);
            int badVersionMask = -((Pack.bigEndianToShort(encoding, plainTextOffset) ^ protocolVersion) & 0xFFFF) >> 31;
            int fallbackMask = badEncodingMask | badVersionMask;
            for (int i = 0; i < 48; ++i) {
                result[i] = (byte)(result[i] & fallbackMask | encoding[plainTextOffset + i] & ~fallbackMask);
            }
            Arrays.fill(encoding, (byte)0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static int getInputLimit(RSAKeyParameters privateKey) {
        return (privateKey.getModulus().bitLength() + 7) / 8;
    }

    private static int caddTo(int len, int cond, byte[] x, byte[] z) {
        int mask = cond & 0xFF;
        int c = 0;
        for (int i = len - 1; i >= 0; --i) {
            z[i] = (byte)(c += (z[i] & 0xFF) + (x[i] & mask));
            c >>>= 8;
        }
        return c;
    }

    private static int checkPkcs1Encoding2(byte[] buf, int pkcs1Length, int plaintextLength) {
        int i;
        int errorSign = pkcs1Length - plaintextLength - 10;
        int firstPadPos = buf.length - pkcs1Length;
        int lastPadPos = buf.length - 1 - plaintextLength;
        for (i = 0; i < firstPadPos; ++i) {
            errorSign |= -(buf[i] & 0xFF);
        }
        errorSign |= -(buf[firstPadPos] & 0xFF ^ 2);
        for (i = firstPadPos + 1; i < lastPadPos; ++i) {
            errorSign |= (buf[i] & 0xFF) - 1;
        }
        return (errorSign |= -(buf[lastPadPos] & 0xFF)) >> 31;
    }

    private static BigInteger convertInput(BigInteger modulus, byte[] in, int inOff, int inLen) {
        BigInteger result = BigIntegers.fromUnsignedByteArray(in, inOff, inLen);
        if (result.compareTo(modulus) < 0) {
            return result;
        }
        throw new DataLengthException("input too large for RSA cipher.");
    }

    private static BigInteger rsa(RSAKeyParameters privateKey, BigInteger input) {
        return input.modPow(privateKey.getExponent(), privateKey.getModulus());
    }

    private static byte[] rsaBlinded(RSAKeyParameters privateKey, BigInteger input, SecureRandom secureRandom) {
        RSAPrivateCrtKeyParameters crtKey;
        BigInteger e;
        BigInteger modulus = privateKey.getModulus();
        int resultSize = modulus.bitLength() / 8 + 1;
        if (privateKey instanceof RSAPrivateCrtKeyParameters && (e = (crtKey = (RSAPrivateCrtKeyParameters)privateKey).getPublicExponent()) != null) {
            BigInteger r = BigIntegers.createRandomInRange(ONE, modulus.subtract(ONE), secureRandom);
            BigInteger blind = r.modPow(e, modulus);
            BigInteger unblind = BigIntegers.modOddInverse(modulus, r);
            BigInteger blindedInput = blind.multiply(input).mod(modulus);
            BigInteger blindedResult = TlsRsaKeyExchange.rsaCrt(crtKey, blindedInput);
            BigInteger offsetResult = unblind.add(ONE).multiply(blindedResult).mod(modulus);
            byte[] blindedResultBytes = TlsRsaKeyExchange.toBytes(blindedResult, resultSize);
            byte[] modulusBytes = TlsRsaKeyExchange.toBytes(modulus, resultSize);
            byte[] resultBytes = TlsRsaKeyExchange.toBytes(offsetResult, resultSize);
            int carry = TlsRsaKeyExchange.subFrom(resultSize, blindedResultBytes, resultBytes);
            TlsRsaKeyExchange.caddTo(resultSize, carry, modulusBytes, resultBytes);
            return resultBytes;
        }
        return TlsRsaKeyExchange.toBytes(TlsRsaKeyExchange.rsa(privateKey, input), resultSize);
    }

    private static BigInteger rsaCrt(RSAPrivateCrtKeyParameters crtKey, BigInteger input) {
        BigInteger e = crtKey.getPublicExponent();
        BigInteger p = crtKey.getP();
        BigInteger q = crtKey.getQ();
        BigInteger dP = crtKey.getDP();
        BigInteger dQ = crtKey.getDQ();
        BigInteger qInv = crtKey.getQInv();
        BigInteger mP = input.remainder(p).modPow(dP, p);
        BigInteger mQ = input.remainder(q).modPow(dQ, q);
        BigInteger h = mP.subtract(mQ);
        h = h.multiply(qInv);
        BigInteger m = (h = h.mod(p)).multiply(q).add(mQ);
        BigInteger check = m.modPow(e, crtKey.getModulus());
        if (!check.equals(input)) {
            throw new IllegalStateException("RSA engine faulty decryption/signing detected");
        }
        return m;
    }

    private static int subFrom(int len, byte[] x, byte[] z) {
        int c = 0;
        for (int i = len - 1; i >= 0; --i) {
            z[i] = (byte)(c += (z[i] & 0xFF) - (x[i] & 0xFF));
            c >>= 8;
        }
        return c;
    }

    private static byte[] toBytes(BigInteger output, int fixedSize) {
        byte[] bytes = output.toByteArray();
        byte[] result = new byte[fixedSize];
        System.arraycopy(bytes, 0, result, result.length - bytes.length, bytes.length);
        return result;
    }
}

