/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.its;

import java.util.ArrayList;
import java.util.List;
import net.savignano.thirdparty.org.bouncycastle.its.ETSIEncryptedData;
import net.savignano.thirdparty.org.bouncycastle.its.ETSIRecipientInfoBuilder;
import net.savignano.thirdparty.org.bouncycastle.its.operator.ETSIDataEncryptor;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.AesCcmCiphertext;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.EncryptedData;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.SequenceOfRecipientInfo;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.SymmetricCiphertext;

public class ETSIEncryptedDataBuilder {
    private final List<ETSIRecipientInfoBuilder> recipientInfoBuilders = new ArrayList<ETSIRecipientInfoBuilder>();

    public void addRecipientInfoBuilder(ETSIRecipientInfoBuilder recipientInfoBuilder) {
        this.recipientInfoBuilders.add(recipientInfoBuilder);
    }

    public ETSIEncryptedData build(ETSIDataEncryptor encryptor, byte[] content) {
        byte[] opaque = encryptor.encrypt(content);
        byte[] key = encryptor.getKey();
        byte[] nonce = encryptor.getNonce();
        SequenceOfRecipientInfo.Builder builder = SequenceOfRecipientInfo.builder();
        for (ETSIRecipientInfoBuilder recipientInfoBuilder : this.recipientInfoBuilders) {
            builder.addRecipients(recipientInfoBuilder.build(key));
        }
        return new ETSIEncryptedData(EncryptedData.builder().setRecipients(builder.createSequenceOfRecipientInfo()).setCiphertext(SymmetricCiphertext.aes128ccm(AesCcmCiphertext.builder().setCcmCiphertext(opaque).setNonce(nonce).createAesCcmCiphertext())).createEncryptedData());
    }
}

