/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.mail.smime.examples;

import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import net.savignano.thirdparty.org.bouncycastle.cms.RecipientInformation;
import net.savignano.thirdparty.org.bouncycastle.cms.RecipientInformationStore;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.JceKeyTransRecipientId;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEEnveloped;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEUtil;

public class ReadEncryptedMail {
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("usage: ReadEncryptedMail pkcs12Keystore password");
            System.exit(0);
        }
        KeyStore ks = KeyStore.getInstance("PKCS12", "SAVIGNANO-BC");
        ks.load(new FileInputStream(args[0]), args[1].toCharArray());
        Enumeration<String> e = ks.aliases();
        String keyAlias = null;
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            if (!ks.isKeyEntry(alias)) continue;
            keyAlias = alias;
        }
        if (keyAlias == null) {
            System.err.println("can't find a private key!");
            System.exit(0);
        }
        X509Certificate cert = (X509Certificate)ks.getCertificate(keyAlias);
        JceKeyTransRecipientId recId = new JceKeyTransRecipientId(cert);
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(session, (InputStream)new FileInputStream("encrypted.message"));
        SMIMEEnveloped m = new SMIMEEnveloped(msg);
        RecipientInformationStore recipients = m.getRecipientInfos();
        RecipientInformation recipient = recipients.get(recId);
        MimeBodyPart res = SMIMEUtil.toMimeBodyPart(recipient.getContent(new JceKeyTransEnvelopedRecipient((PrivateKey)ks.getKey(keyAlias, null)).setProvider("SAVIGNANO-BC")));
        System.out.println("Message Contents");
        System.out.println("----------------");
        System.out.println(res.getContent());
    }
}

