/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPAlgorithmParameters;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPKeyPair;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;

public class JcaPGPKeyPair
extends PGPKeyPair {
    private static PGPPublicKey getPublicKey(int algorithm, PublicKey pubKey, Date date) throws PGPException {
        return new JcaPGPKeyConverter().getPGPPublicKey(algorithm, pubKey, date);
    }

    private static PGPPublicKey getPublicKey(int algorithm, PGPAlgorithmParameters algorithmParameters, PublicKey pubKey, Date date) throws PGPException {
        return new JcaPGPKeyConverter().getPGPPublicKey(algorithm, algorithmParameters, pubKey, date);
    }

    private static PGPPrivateKey getPrivateKey(PGPPublicKey pub, PrivateKey privKey) throws PGPException {
        return new JcaPGPKeyConverter().getPGPPrivateKey(pub, privKey);
    }

    public JcaPGPKeyPair(int algorithm, KeyPair keyPair, Date date) throws PGPException {
        this.pub = JcaPGPKeyPair.getPublicKey(algorithm, keyPair.getPublic(), date);
        this.priv = JcaPGPKeyPair.getPrivateKey(this.pub, keyPair.getPrivate());
    }

    public JcaPGPKeyPair(int algorithm, PGPAlgorithmParameters parameters, KeyPair keyPair, Date date) throws PGPException {
        this.pub = JcaPGPKeyPair.getPublicKey(algorithm, parameters, keyPair.getPublic(), date);
        this.priv = JcaPGPKeyPair.getPrivateKey(this.pub, keyPair.getPrivate());
    }
}

