/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.savignano.thirdparty.org.bouncycastle.bcpg.AEADEncDataPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.AEADUtils;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SymmetricKeyUtils;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.SHA256Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.HKDFParameters;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSessionKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JceAEADCipherUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.SHA1PGPDigestCalculator;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.Exceptions;
import net.savignano.thirdparty.org.bouncycastle.util.Pack;
import net.savignano.thirdparty.org.bouncycastle.util.io.Streams;

class JceAEADUtil {
    private final OperatorHelper helper;

    public JceAEADUtil(OperatorHelper helper) {
        this.helper = helper;
    }

    protected static byte[] getNonce(byte[] iv, long chunkIndex) {
        byte[] nonce = Arrays.clone(iv);
        JceAEADUtil.xorChunkId(nonce, chunkIndex);
        return nonce;
    }

    protected static void xorChunkId(byte[] nonce, long chunkIndex) {
        int index = nonce.length - 8;
        int n = index++;
        nonce[n] = (byte)(nonce[n] ^ (byte)(chunkIndex >> 56));
        int n2 = index++;
        nonce[n2] = (byte)(nonce[n2] ^ (byte)(chunkIndex >> 48));
        int n3 = index++;
        nonce[n3] = (byte)(nonce[n3] ^ (byte)(chunkIndex >> 40));
        int n4 = index++;
        nonce[n4] = (byte)(nonce[n4] ^ (byte)(chunkIndex >> 32));
        int n5 = index++;
        nonce[n5] = (byte)(nonce[n5] ^ (byte)(chunkIndex >> 24));
        int n6 = index++;
        nonce[n6] = (byte)(nonce[n6] ^ (byte)(chunkIndex >> 16));
        int n7 = index++;
        nonce[n7] = (byte)(nonce[n7] ^ (byte)(chunkIndex >> 8));
        int n8 = index;
        nonce[n8] = (byte)(nonce[n8] ^ (byte)chunkIndex);
    }

    protected static long getChunkLength(int chunkSize) {
        return 1L << chunkSize + 6;
    }

    static byte[][] deriveMessageKeyAndIv(int aeadAlgo, int cipherAlgo, byte[] sessionKey, byte[] salt, byte[] hkdfInfo) throws PGPException {
        HKDFParameters hkdfParameters = new HKDFParameters(sessionKey, salt, hkdfInfo);
        HKDFBytesGenerator hkdfGen = new HKDFBytesGenerator(new SHA256Digest());
        hkdfGen.init(hkdfParameters);
        int keyLen = SymmetricKeyUtils.getKeyLengthInOctets(cipherAlgo);
        int ivLen = AEADUtils.getIVLength(aeadAlgo);
        byte[] messageKeyAndIv = new byte[keyLen + ivLen - 8];
        hkdfGen.generateBytes(messageKeyAndIv, 0, messageKeyAndIv.length);
        return new byte[][]{Arrays.copyOfRange(messageKeyAndIv, 0, keyLen), Arrays.copyOfRange(messageKeyAndIv, keyLen, keyLen + ivLen)};
    }

    PGPDataDecryptor createOpenPgpV5DataDecryptor(AEADEncDataPacket aeadEncDataPacket, PGPSessionKey sessionKey) throws PGPException {
        final byte aeadAlgorithm = aeadEncDataPacket.getAEADAlgorithm();
        final byte[] iv = aeadEncDataPacket.getIV();
        final int chunkSize = aeadEncDataPacket.getChunkSize();
        final int encAlgorithm = sessionKey.getAlgorithm();
        byte[] key = sessionKey.getKey();
        final byte[] aaData = aeadEncDataPacket.getAAData();
        try {
            final SecretKeySpec secretKey = new SecretKeySpec(key, PGPUtil.getSymmetricCipherName(encAlgorithm));
            final Cipher c = this.createAEADCipher(encAlgorithm, aeadAlgorithm);
            return new PGPDataDecryptor(){

                @Override
                public InputStream getInputStream(InputStream in) {
                    try {
                        return new PGPAeadInputStream(true, in, c, secretKey, iv, encAlgorithm, aeadAlgorithm, chunkSize, aaData);
                    }
                    catch (IOException e) {
                        throw Exceptions.illegalStateException("unable to open stream: " + e.getMessage(), e);
                    }
                }

                @Override
                public int getBlockSize() {
                    return c.getBlockSize();
                }

                @Override
                public PGPDigestCalculator getIntegrityCalculator() {
                    return new SHA1PGPDigestCalculator();
                }
            };
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception creating cipher", e);
        }
    }

    PGPDataDecryptor createOpenPgpV6DataDecryptor(SymmetricEncIntegrityPacket seipd, PGPSessionKey sessionKey) throws PGPException {
        final int cipherAlgo = seipd.getCipherAlgorithm();
        final int aeadAlgo = seipd.getAeadAlgorithm();
        final int chunkSize = seipd.getChunkSize();
        byte[] salt = seipd.getSalt();
        final byte[] aaData = seipd.getAAData();
        byte[][] messageKeyAndIv = JceAEADUtil.deriveMessageKeyAndIv(aeadAlgo, cipherAlgo, sessionKey.getKey(), salt, aaData);
        byte[] messageKey = messageKeyAndIv[0];
        final byte[] iv = messageKeyAndIv[1];
        try {
            final SecretKeySpec secretKey = new SecretKeySpec(messageKey, PGPUtil.getSymmetricCipherName(cipherAlgo));
            final Cipher c = this.createAEADCipher(cipherAlgo, aeadAlgo);
            return new PGPDataDecryptor(){

                @Override
                public InputStream getInputStream(InputStream in) {
                    try {
                        return new PGPAeadInputStream(false, in, c, secretKey, iv, cipherAlgo, aeadAlgo, chunkSize, aaData);
                    }
                    catch (IOException e) {
                        throw Exceptions.illegalStateException("unable to open stream: " + e.getMessage(), e);
                    }
                }

                @Override
                public int getBlockSize() {
                    return c.getBlockSize();
                }

                @Override
                public PGPDigestCalculator getIntegrityCalculator() {
                    return new SHA1PGPDigestCalculator();
                }
            };
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception creating cipher", e);
        }
    }

    Cipher createAEADCipher(int encAlgorithm, int aeadAlgorithm) throws PGPException {
        String mode;
        if (encAlgorithm != 7 && encAlgorithm != 8 && encAlgorithm != 9 && encAlgorithm != 11 && encAlgorithm != 12 && encAlgorithm != 13) {
            throw new PGPException("AEAD only supported for AES and Camellia based algorithms");
        }
        switch (aeadAlgorithm) {
            case 1: {
                mode = "EAX";
                break;
            }
            case 2: {
                mode = "OCB";
                break;
            }
            case 3: {
                mode = "GCM";
                break;
            }
            default: {
                throw new PGPException("encountered unknown AEAD algorithm: " + aeadAlgorithm);
            }
        }
        String cName = PGPUtil.getSymmetricCipherName(encAlgorithm) + "/" + mode + "/NoPadding";
        return this.helper.createCipher(cName);
    }

    static class PGPAeadOutputStream
    extends OutputStream {
        private final boolean isV5AEAD;
        private final OutputStream out;
        private final byte[] data;
        private final Cipher c;
        private final SecretKey secretKey;
        private final byte[] aaData;
        private final byte[] iv;
        private final int chunkLength;
        private int dataOff;
        private long chunkIndex = 0L;
        private long totalBytes = 0L;

        public PGPAeadOutputStream(boolean isV5AEAD, OutputStream out, Cipher c, SecretKey secretKey, byte[] iv, int encAlgorithm, int aeadAlgorithm, int chunkSize) {
            this.isV5AEAD = isV5AEAD;
            this.out = out;
            this.iv = iv;
            this.chunkLength = (int)JceAEADUtil.getChunkLength(chunkSize);
            this.data = new byte[this.chunkLength];
            this.c = c;
            this.secretKey = secretKey;
            this.aaData = this.createAAD(isV5AEAD, encAlgorithm, aeadAlgorithm, chunkSize);
        }

        private byte[] createAAD(boolean isV5AEAD, int encAlgorithm, int aeadAlgorithm, int chunkSize) {
            if (isV5AEAD) {
                return AEADEncDataPacket.createAAData(1, encAlgorithm, aeadAlgorithm, chunkSize);
            }
            return SymmetricEncIntegrityPacket.createAAData(2, encAlgorithm, aeadAlgorithm, chunkSize);
        }

        @Override
        public void write(int b) throws IOException {
            if (this.dataOff == this.data.length) {
                this.writeBlock();
            }
            this.data[this.dataOff++] = (byte)b;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.dataOff == this.data.length) {
                this.writeBlock();
            }
            if (len < this.data.length - this.dataOff) {
                System.arraycopy(b, off, this.data, this.dataOff, len);
                this.dataOff += len;
            } else {
                int gap = this.data.length - this.dataOff;
                System.arraycopy(b, off, this.data, this.dataOff, gap);
                this.dataOff += gap;
                this.writeBlock();
                len -= gap;
                off += gap;
                while (len >= this.data.length) {
                    System.arraycopy(b, off, this.data, 0, this.data.length);
                    this.dataOff = this.data.length;
                    this.writeBlock();
                    len -= this.data.length;
                    off += this.data.length;
                }
                if (len > 0) {
                    System.arraycopy(b, off, this.data, 0, len);
                    this.dataOff = len;
                }
            }
        }

        @Override
        public void close() throws IOException {
            this.finish();
        }

        private void writeBlock() throws IOException {
            byte[] adata = this.isV5AEAD ? new byte[13] : new byte[this.aaData.length];
            System.arraycopy(this.aaData, 0, adata, 0, this.aaData.length);
            if (this.isV5AEAD) {
                JceAEADUtil.xorChunkId(adata, this.chunkIndex);
            }
            try {
                JceAEADCipherUtil.setUpAeadCipher(this.c, this.secretKey, 1, JceAEADUtil.getNonce(this.iv, this.chunkIndex), 128, adata);
                this.out.write(this.c.doFinal(this.data, 0, this.dataOff));
            }
            catch (GeneralSecurityException e) {
                throw new IOException("exception processing chunk " + this.chunkIndex + ": " + e.getMessage());
            }
            this.totalBytes += (long)this.dataOff;
            ++this.chunkIndex;
            this.dataOff = 0;
        }

        private void finish() throws IOException {
            if (this.dataOff > 0) {
                this.writeBlock();
            }
            byte[] adata = PGPAeadOutputStream.getAdata(this.isV5AEAD, this.aaData, this.chunkIndex, this.totalBytes);
            try {
                if (this.isV5AEAD) {
                    JceAEADCipherUtil.setUpAeadCipher(this.c, this.secretKey, 1, JceAEADUtil.getNonce(this.iv, this.chunkIndex), 128, Arrays.concatenate(adata, Pack.longToBigEndian(this.totalBytes)));
                } else {
                    JceAEADCipherUtil.setUpAeadCipher(this.c, this.secretKey, 1, JceAEADUtil.getNonce(this.iv, this.chunkIndex), 128, adata);
                }
                this.out.write(this.c.doFinal(this.aaData, 0, 0));
            }
            catch (GeneralSecurityException e) {
                throw new IOException("exception processing final tag: " + e.getMessage());
            }
            this.out.close();
        }

        private static byte[] getAdata(boolean isV5AEAD, byte[] aaData, long chunkIndex, long totalBytes) {
            byte[] adata;
            if (isV5AEAD) {
                adata = new byte[13];
                System.arraycopy(aaData, 0, adata, 0, aaData.length);
                JceAEADUtil.xorChunkId(adata, chunkIndex);
            } else {
                adata = new byte[aaData.length + 8];
                System.arraycopy(aaData, 0, adata, 0, aaData.length);
                System.arraycopy(Pack.longToBigEndian(totalBytes), 0, adata, aaData.length, 8);
            }
            return adata;
        }
    }

    static class PGPAeadInputStream
    extends InputStream {
        private final InputStream in;
        private final byte[] buf;
        private final Cipher c;
        private final SecretKey secretKey;
        private final byte[] aaData;
        private final byte[] iv;
        private final int chunkLength;
        private final int aeadTagLength;
        private byte[] data;
        private int dataOff;
        private long chunkIndex = 0L;
        private long totalBytes = 0L;
        private boolean v5StyleAEAD;

        public PGPAeadInputStream(boolean isV5AEAD, InputStream in, Cipher c, SecretKey secretKey, byte[] iv, int encAlgorithm, int aeadAlgorithm, int chunkSize, byte[] aaData) throws IOException {
            this.v5StyleAEAD = isV5AEAD;
            this.in = in;
            this.iv = iv;
            this.chunkLength = (int)JceAEADUtil.getChunkLength(chunkSize);
            this.aeadTagLength = AEADUtils.getAuthTagLength(aeadAlgorithm);
            this.buf = new byte[this.chunkLength + this.aeadTagLength + this.aeadTagLength];
            this.c = c;
            this.secretKey = secretKey;
            this.aaData = aaData;
            Streams.readFully(in, this.buf, 0, this.aeadTagLength + this.aeadTagLength);
            this.data = this.readBlock();
            this.dataOff = 0;
        }

        @Override
        public int read() throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            return this.data[this.dataOff++] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            int supplyLen = Math.min(len, this.available());
            System.arraycopy(this.data, this.dataOff, b, off, supplyLen);
            this.dataOff += supplyLen;
            return supplyLen;
        }

        @Override
        public long skip(long n) throws IOException {
            if (n <= 0L) {
                return 0L;
            }
            int skip = (int)Math.min(n, (long)this.available());
            this.dataOff += skip;
            return skip;
        }

        @Override
        public int available() throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            return this.data.length - this.dataOff;
        }

        private byte[] readBlock() throws IOException {
            byte[] decData;
            int dataLen = Streams.readFully(this.in, this.buf, this.aeadTagLength + this.aeadTagLength, this.chunkLength);
            if (dataLen == 0) {
                return null;
            }
            byte[] adata = new byte[this.v5StyleAEAD ? 13 : this.aaData.length];
            System.arraycopy(this.aaData, 0, adata, 0, this.aaData.length);
            if (this.v5StyleAEAD) {
                JceAEADUtil.xorChunkId(adata, this.chunkIndex);
            }
            try {
                JceAEADCipherUtil.setUpAeadCipher(this.c, this.secretKey, 2, JceAEADUtil.getNonce(this.iv, this.chunkIndex), 128, adata);
                decData = this.c.doFinal(this.buf, 0, dataLen + this.aeadTagLength);
            }
            catch (GeneralSecurityException e) {
                throw new IOException("exception processing chunk " + this.chunkIndex + ": " + e.getMessage());
            }
            this.totalBytes += (long)decData.length;
            ++this.chunkIndex;
            System.arraycopy(this.buf, dataLen + this.aeadTagLength, this.buf, 0, this.aeadTagLength);
            if (dataLen != this.chunkLength) {
                adata = PGPAeadOutputStream.getAdata(this.v5StyleAEAD, this.aaData, this.chunkIndex, this.totalBytes);
                try {
                    if (this.v5StyleAEAD) {
                        JceAEADCipherUtil.setUpAeadCipher(this.c, this.secretKey, 2, JceAEADUtil.getNonce(this.iv, this.chunkIndex), 128, Arrays.concatenate(adata, Pack.longToBigEndian(this.totalBytes)));
                    } else {
                        JceAEADCipherUtil.setUpAeadCipher(this.c, this.secretKey, 2, JceAEADUtil.getNonce(this.iv, this.chunkIndex), 128, adata);
                    }
                    this.c.doFinal(this.buf, 0, this.aeadTagLength);
                }
                catch (GeneralSecurityException e) {
                    throw new IOException("exception processing final tag: " + e.getMessage());
                }
            } else {
                Streams.readFully(this.in, this.buf, this.aeadTagLength, this.aeadTagLength);
            }
            return decData;
        }
    }
}

