/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.sign;

import jakarta.mail.Session;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimePart;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.key.pgp.PgpSignKey;
import net.savignano.cryptography.mail.sign.AMailSigner;
import net.savignano.cryptography.mail.sign.PgpSigningResult;
import net.savignano.cryptography.mail.visitor.ManipulateMessageVisitor;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKey;

public class InlinePgpMailSigner
extends AMailSigner<PgpSignKey, PgpSigningResult> {
    public InlinePgpMailSigner(Session session) {
        super(session, ECryptographyType.PGP);
    }

    @Override
    protected PgpSigningResult createResult(MimeMessage msg) {
        return new PgpSigningResult(msg);
    }

    @Override
    protected void sign(PgpSignKey key, PgpSigningResult result) throws Exception {
        final PGPSecretKey secKey = key.getKey();
        final char[] password = key.getPassword();
        int hashAlgorithm = 8;
        ManipulateMessageVisitor visitor = new ManipulateMessageVisitor(){
            {
                this.setContentType("text/plain");
            }

            @Override
            protected void handlePart(MimePart part) throws Exception {
                this.getLog().debug("Found text/plain part to sign.");
                ContentType contentType = new ContentType(part.getContentType());
                String text = (String)part.getContent();
                String charset = contentType.getParameter("charset");
                charset = charset == null ? "UTF-8" : charset;
                StringBuilder builder = new StringBuilder(3 * text.length());
                builder.append("-----BEGIN PGP SIGNED MESSAGE-----\r\n");
                builder.append("Hash: ");
                builder.append(PgpUtil.getHashName(8));
                builder.append("\r\n\r\n");
                builder.append(text);
                builder.append("\r\n");
                this.getLog().debug("Signing text part with key: {}", (Object)secKey);
                byte[] signedBytes = PgpUtil.sign(text.getBytes(charset), secKey, password, 8, true);
                builder.append(new String(signedBytes, charset));
                part.setText(builder.toString(), charset);
                this.setChanged(true);
            }
        };
        MimeMessage msg = result.getMessage();
        visitor.visit(msg);
        if (visitor.isChanged()) {
            String hashName = PgpUtil.getHashName(8);
            this.includeSignatureHeader(msg, hashName);
            msg.saveChanges();
        } else {
            this.getLog().warn("Found no text/plain content part in message with ID {}. Nothing was signed.", (Object)msg.getMessageID());
        }
    }
}

