/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.access.pgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.security.access.AUserKeyLoader;
import net.savignano.snotify.atlassian.common.user.IUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpUserKeyLoader
extends AUserKeyLoader<PgpEncryptionKey> {
    private static final Logger log = LoggerFactory.getLogger(PgpUserKeyLoader.class);

    public PgpUserKeyLoader(ISnotifyUserProperties userProps) {
        super(userProps);
    }

    @Override
    protected PgpEncryptionKey loadInternalKey(IUser<?> user) throws Exception {
        ISnotifyUserProperties userProps = this.getUserProperties();
        Long keyId = userProps.getLong(EProperty.EMAIL_PGP_KEY_ID, user);
        byte[] keyBytes = userProps.getBytes(EProperty.EMAIL_PGP_KEY, user);
        if (keyId != null && keyBytes != null) {
            log.debug("Loading cached public key of user {} from user properties.", user);
            try {
                PgpEncryptionKey key = new PgpEncryptionKey(PgpUtil.loadPublicKey(new ByteArrayInputStream(keyBytes)), user.getEmail());
                key.setKeySource(this.getUserKeySource(user));
                return key;
            }
            catch (IOException e) {
                log.error("Could not load cached public key of user " + String.valueOf(user) + " because an exception occured. Error message: " + e.getMessage(), (Throwable)e);
                return this.getValidityKey(EKeyValidity.ERROR);
            }
        }
        log.debug("User {} has no cached public key stored.", user);
        return this.getValidityKey(EKeyValidity.NOT_FOUND);
    }

    private EKeySource getUserKeySource(IUser<?> user) {
        return this.getUserProperties().getEnum(EProperty.EMAIL_PGP_KEY_SOURCE, EKeySource.class, user);
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.PGP;
    }

    @Override
    protected PgpEncryptionKey getValidityKey(EKeyValidity validity) {
        return new PgpEncryptionKey(validity, this.getKeySource());
    }
}

