/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.update;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import net.savignano.cryptography.version.NormalizedVersion;
import net.savignano.snotify.atlassian.common.update.ISnotifyUpdateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyUpdateManager
implements ISnotifyUpdateManager {
    private static final Logger log = LoggerFactory.getLogger(SnotifyUpdateManager.class);
    private final SortedMap<NormalizedVersion, List<Runnable>> updater = new TreeMap<NormalizedVersion, List<Runnable>>();
    private boolean init;

    protected static final boolean isInRange(NormalizedVersion version, NormalizedVersion lowerVersion, NormalizedVersion upperVersion) {
        return lowerVersion.isLowerThan(version) && !upperVersion.isLowerThan(version);
    }

    @Override
    public void update(NormalizedVersion oldVersion, NormalizedVersion newVersion) {
        NormalizedVersion nV;
        log.debug("Updating from {} to {}", (Object)oldVersion, (Object)newVersion);
        NormalizedVersion oV = oldVersion;
        if (oV == null) {
            oV = new NormalizedVersion(0);
        }
        if ((nV = newVersion) == null) {
            nV = new NormalizedVersion(Integer.MAX_VALUE);
        }
        if (oV.isLowerThan(nV)) {
            if (!this.init) {
                this.initialize();
                this.init = true;
            }
            if (!this.updater.isEmpty()) {
                this.process(oV, nV);
            }
        }
    }

    protected void initialize() {
        log.debug("Initializing update manager.");
    }

    private void process(NormalizedVersion oldVersion, NormalizedVersion newVersion) {
        log.info("Starting update of S/Notify to version {}.", (Object)newVersion);
        for (Map.Entry<NormalizedVersion, List<Runnable>> entry : this.updater.entrySet()) {
            NormalizedVersion version = entry.getKey();
            if (!SnotifyUpdateManager.isInRange(version, oldVersion, newVersion)) continue;
            for (Runnable runnable : entry.getValue()) {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    log.error("Update process failed. Error message: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        log.info("Update of S/Notify to version {} finished.", (Object)newVersion);
    }

    public void add(NormalizedVersion version, Runnable runnable) {
        Objects.requireNonNull(version);
        Objects.requireNonNull(runnable);
        ArrayList<Runnable> list = (ArrayList<Runnable>)this.updater.get(version);
        if (list == null) {
            list = new ArrayList<Runnable>();
            this.updater.put(version, list);
        }
        list.add(runnable);
    }

    public void add(String version, Runnable runnable) {
        Objects.requireNonNull(version);
        this.add(new NormalizedVersion(version), runnable);
    }
}

