/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.event.events.PluginDisablingEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.event.events.PluginRefreshedEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseEventRegistry;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.license.event.PluginLicenseEvent;
import com.atlassian.upm.api.util.Option;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.savignano.cryptography.Constants;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.cryptography.version.FullVersion;
import net.savignano.cryptography.version.IVersion;
import net.savignano.cryptography.version.NormalizedVersion;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.update.ISnotifyUpdateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class APluginListener
implements IVersion {
    private static final Logger log = LoggerFactory.getLogger(APluginListener.class);
    private static final String CONFIG_FILE = "/images/tiny_logo.png";
    private static final String FULL_CAPABILITY = "Managed";
    private static final String DEV_MODE = "Development";
    @Autowired
    @ComponentImport
    private PluginController controller;
    @Autowired
    @ComponentImport
    private EventPublisher publisher;
    @Autowired
    @ComponentImport
    private PluginLicenseEventRegistry pluginPublisher;
    @Autowired
    @ComponentImport
    private PluginLicenseManager licenseManager;
    @Autowired
    @ComponentImport
    private PluginAccessor pluginAccessor;
    @Autowired
    private ISnotifyAppProperties appProperties;
    @Autowired
    private ISnotifyUpdateManager updateManager;

    @PostConstruct
    public void init() {
        log.info("Initializing S/Notify Plugin.");
        log.debug("License Manager registered for plugin key: {}", (Object)this.licenseManager.getPluginKey());
        this.publisher.register((Object)this);
        this.pluginPublisher.register((Object)this);
    }

    @PreDestroy
    public void destroy() {
        log.info("Removing S/Notify Plugin.");
        this.publisher.unregister((Object)this);
        this.pluginPublisher.unregister((Object)this);
    }

    @Override
    public String getVersion() {
        return this.getManifestVersion().getVersion();
    }

    @EventListener
    public void refresh(PluginRefreshedEvent event) {
        if (this.isRelevant((PluginEvent)event)) {
            log.debug("Plugin Refreshed Event for S/Notify detected: {}", (Object)event);
            String config = this.getConfig();
            this.checkDev(config);
            if (this.checkSignature()) {
                this.logPluginVersion();
                this.logManifestVersion();
                this.checkLite(config);
                this.checkLicense();
                this.checkUpdate();
                this.checkMailerVersion();
                this.destroyCache();
                this.createCache();
            }
        }
    }

    @EventListener
    public void enabled(PluginEnabledEvent event) {
        if (this.isRelevant((PluginEvent)event)) {
            log.info("Plugin Enabled Event for S/Notify detected: {}", (Object)event);
            this.setPluginKey(this.licenseManager.getPluginKey());
            this.setDisablement(false);
            this.initBcProvider(true);
            String config = this.getConfig();
            this.checkDev(config);
            if (this.checkSignature()) {
                this.logPluginVersion();
                this.logManifestVersion();
                this.checkLite(config);
                this.checkLicense();
                this.checkUpdate();
                this.checkMailerVersion();
                this.createCache();
            }
        }
    }

    @EventListener
    public void disabled(PluginDisablingEvent event) {
        if (this.isRelevant((PluginEvent)event)) {
            log.warn("Plugin Disabling Event for S/Notify detected: {}", (Object)event);
            this.setPluginKey(null);
            this.setDisablement(true);
            this.initBcProvider(false);
            this.destroyCache();
        }
    }

    @EventListener
    public void startup(PluginFrameworkStartedEvent event) {
        log.debug("Plugin Framework Start Event for S/Notify detected: {}", (Object)event);
        this.setPluginKey(this.licenseManager.getPluginKey());
        String config = this.getConfig();
        this.checkDev(config);
        if (this.checkSignature()) {
            this.logPluginVersion();
            this.logManifestVersion();
            this.checkLite(config);
            this.checkLicense();
            this.checkUpdate();
            this.checkMailerVersion();
            this.createCache();
        }
    }

    @EventListener
    public void license(PluginLicenseEvent event) {
        if (this.isRelevant(event.getPluginKey())) {
            log.debug("Plugin License Event for S/Notify detected: {}", (Object)event);
            this.checkLite(this.getConfig());
            this.checkLicense();
        }
    }

    private void initBcProvider(boolean init) {
        if (init) {
            SecurityUtil.getProvider();
        } else {
            SecurityUtil.clearProvider();
        }
    }

    private void checkLicense() {
        this.printLicense();
        boolean freeze = this.isFreezeSnotify();
        boolean oldFreeze = this.appProperties.getBoolean(EProperty.FREEZE_SNOTIFY);
        if (oldFreeze != freeze) {
            if (freeze) {
                log.info("S/Notify mailer was frozen because of an invalid license.");
            } else {
                log.info("S/Notify mailer was restored. Proper license found.");
            }
            this.appProperties.setBoolean(EProperty.FREEZE_SNOTIFY, freeze);
        }
    }

    private void checkDev(String config) {
        if (config != null) {
            boolean oldDev = this.appProperties.getBoolean(EProperty.DEV_MODE);
            if (config.contains(DEV_MODE)) {
                log.debug("S/Notify Development mode recognized.");
                if (!oldDev) {
                    this.appProperties.setBoolean(EProperty.DEV_MODE, true);
                }
            } else if (oldDev) {
                this.appProperties.setBoolean(EProperty.DEV_MODE, false);
            }
        }
    }

    private void checkLite(String config) {
        if (config != null) {
            boolean oldLite = this.appProperties.getBoolean(EProperty.LITE_MODE);
            if (config.contains(FULL_CAPABILITY)) {
                log.info("S/Notify Professional version recognized.");
                if (oldLite) {
                    this.appProperties.setBoolean(EProperty.LITE_MODE, false);
                }
            } else {
                log.info("S/Notify Lite version recognized.");
                if (!oldLite) {
                    this.appProperties.setBoolean(EProperty.LITE_MODE, true);
                }
            }
        }
    }

    protected boolean checkSignature() {
        if (this.appProperties.getBoolean(EProperty.DEV_MODE)) {
            log.debug("Skipping signature check.");
            return true;
        }
        if (SecurityUtil.checkSelfIntegrity()) {
            log.info("Signature of S/Notify is correct.");
            return true;
        }
        log.error("Signature of S/Notify is not correct. To protect underlying system, S/Notify will be disabled, as it has been tampered with.");
        this.controller.disablePluginWithoutPersisting(this.licenseManager.getPluginKey());
        return false;
    }

    private void checkMailerVersion() {
        try {
            this.setMailerVersion();
        }
        catch (Exception e) {
            log.error("Could not check mailer library version. Error message: " + e.getMessage(), (Throwable)e);
            return;
        }
        FullVersion mailerVersion = new FullVersion(this.appProperties.getString(EProperty.MAILER_VERSION));
        log.info("S/Notify mailer library version: {}", (Object)mailerVersion);
        if (!this.match(mailerVersion)) {
            if (mailerVersion.match("<N/A>")) {
                log.error("S/Notify mailer library has not been detected. Please make sure to install S/Notify mailer library to your 'lib' directory, so emails can be encrypted.");
            } else {
                NormalizedVersion normalMailerVersion = new NormalizedVersion(mailerVersion);
                NormalizedVersion normalGuiVersion = new NormalizedVersion(this.getVersion());
                if (!normalMailerVersion.match(normalGuiVersion)) {
                    log.error("S/Notify mailer library has different version than S/Notify GUI plugin. Please make sure to install S/Notify mailer library in version {} to your 'lib' directory, to match the installed GUI plugin.", (Object)this.getVersion());
                } else {
                    log.warn("S/Notify mailer library has different build time than S/Notify GUI plugin. This should usually not be a problem, but should be fixed anyway to ensure no unexpected behavior is occuring. For this, make sure to install S/Notify mailer library in version {} to your 'lib' directory, to match the installed GUI plugin.", (Object)this.getVersion());
                }
            }
        }
    }

    private void checkUpdate() {
        String oldVersion = this.appProperties.getString(EProperty.GUI_VERSION);
        log.debug("Last known GUI version: {}", (Object)oldVersion);
        if (!this.match(oldVersion)) {
            String newVersion = this.getVersion();
            log.debug("New GUI version: {}", (Object)newVersion);
            this.setPluginVersion(newVersion);
            this.updateManager.update(oldVersion, newVersion);
        }
    }

    protected abstract void setMailerVersion();

    protected abstract void createCache();

    protected abstract void destroyCache();

    private FullVersion getPluginVersion() {
        String pluginKey = this.licenseManager.getPluginKey();
        return new FullVersion(this.pluginAccessor.getPlugin(pluginKey).getPluginInformation().getVersion());
    }

    private void logPluginVersion() {
        log.info("S/Notify GUI plugin version: {}", (Object)this.getPluginVersion());
    }

    private FullVersion getManifestVersion() {
        String compileTime;
        String versionNo = SecurityUtil.getManifestValue("Bundle-Version");
        if (versionNo == null) {
            log.debug("GUI plugin is missing bundle version in manifest.");
            versionNo = "<N/A>";
        }
        if ((compileTime = SecurityUtil.getManifestValue("Compile-Time")) == null) {
            log.debug("GUI plugin is missing compile time in manifest.");
            compileTime = "<N/A>";
        }
        StringBuilder builder = new StringBuilder(30);
        builder.append(versionNo);
        builder.append(" (");
        builder.append(compileTime);
        builder.append(')');
        return new FullVersion(builder.toString());
    }

    private void logManifestVersion() {
        log.info("S/Notify GUI manifest version: {}", (Object)this.getManifestVersion());
    }

    private boolean isRelevant(PluginEvent event) {
        return this.isRelevant(event.getPlugin().getKey());
    }

    private boolean isRelevant(String pluginKey) {
        boolean isRelevant = this.licenseManager.getPluginKey().equalsIgnoreCase(pluginKey);
        log.trace("Is event for plugin key {} relevant: ", (Object)pluginKey, (Object)isRelevant);
        return isRelevant;
    }

    private void setDisablement(boolean disable) {
        boolean oldDisabled = this.appProperties.getBoolean(EProperty.DISABLE_SNOTIFY);
        if (oldDisabled != disable) {
            if (disable) {
                log.info("Disabling S/Notify mailer.");
            } else {
                log.info("Enabling S/Notify mailer.");
            }
            this.appProperties.setBoolean(EProperty.DISABLE_SNOTIFY, disable);
        }
    }

    private void setPluginKey(String key) {
        this.appProperties.setString(EProperty.GUI_KEY, key);
    }

    private void setPluginVersion(String version) {
        this.appProperties.setString(EProperty.GUI_VERSION, version);
    }

    private boolean isFreezeSnotify() {
        Option licenseOption = this.licenseManager.getLicense();
        if (licenseOption.isDefined()) {
            PluginLicense license = (PluginLicense)licenseOption.get();
            return !license.isValid();
        }
        return true;
    }

    private String getConfig() {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(CONFIG_FILE), Constants.UTF8_CHARSET));
        try {
            string = reader.readLine();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.error("Could not access config file.", (Throwable)e);
                return null;
            }
        }
        reader.close();
        return string;
    }

    private void printLicense() {
        if (!log.isDebugEnabled()) {
            return;
        }
        Option option = this.licenseManager.getLicense();
        if (option.isDefined()) {
            PluginLicense license = (PluginLicense)option.get();
            String licenseStr = license.toString();
            String rawLicense = license.getRawLicense();
            if (rawLicense.length() > 16) {
                String shortenedLicense = rawLicense.substring(0, 8) + "[...]" + rawLicense.substring(rawLicense.length() - 8);
                licenseStr = licenseStr.replace(rawLicense, shortenedLicense);
            }
            log.debug("S/Notify license: {}", (Object)licenseStr);
            if (license.getError().isDefined()) {
                LicenseError licenseError = (LicenseError)license.getError().get();
                log.debug("S/Notify license error: {}", (Object)licenseError);
            }
        } else {
            log.debug("No license for S/Notify defined.");
        }
    }

    public ISnotifyAppProperties getAppProps() {
        return this.appProperties;
    }
}

