/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.common;

import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import jakarta.mail.Address;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.snotify.atlassian.common.user.IUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraUser
implements IUser<ApplicationUser> {
    private static final Logger log = LoggerFactory.getLogger(JiraUser.class);
    private final ApplicationUser user;

    public static final JiraUser lookupUser(Address address) {
        return JiraUser.lookupUser(MessageUtil.getEmail(address));
    }

    public static final JiraUser lookupUser(String email) {
        List<JiraUser> users = JiraUser.lookupUsers(email);
        switch (users.size()) {
            case 0: {
                log.info("No user found for email: {}", (Object)email);
                return null;
            }
            case 1: {
                return users.get(0);
            }
        }
        log.warn("Multiple users found for email {}. First user found is used, but this can be unpredictable: {}", (Object)email, users);
        return users.get(0);
    }

    public static final List<JiraUser> lookupUsers(Address address) {
        return JiraUser.lookupUsers(MessageUtil.getEmail(address));
    }

    public static final List<JiraUser> lookupUsers(String email) {
        if (email == null) {
            return Collections.emptyList();
        }
        ArrayList<JiraUser> list = new ArrayList<JiraUser>();
        UserSearchService service = (UserSearchService)ComponentAccessor.getComponent(UserSearchService.class);
        for (ApplicationUser user : service.findUsersByEmail(email)) {
            if (user.isActive()) {
                list.add(new JiraUser(user));
                continue;
            }
            log.info("User {} is inactive. It will not be considered for email encryption.", (Object)user);
        }
        log.debug("Found users for email \"{}\": {}", (Object)email, list);
        return list;
    }

    public JiraUser(ApplicationUser user) {
        if (user == null) {
            throw new IllegalArgumentException("User must not be null.");
        }
        this.user = user;
    }

    @Override
    public String getDisplayName() {
        return this.user.getDisplayName();
    }

    @Override
    public String getEmail() {
        return this.user.getEmailAddress();
    }

    @Override
    public ApplicationUser getActualUser() {
        return this.user;
    }

    public String toString() {
        return this.user.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JiraUser other = (JiraUser)obj;
        if (this.user == null) {
            if (other.user != null) {
                return false;
            }
        } else {
            String key = this.user.getKey();
            String otherKey = other.user.getKey();
            if (this.user == null ? other.user != null : !key.equals(otherKey)) {
                return false;
            }
        }
        return true;
    }
}

