/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.gui;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.security.cert.X509Certificate;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.properties.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.security.access.pgp.PgpCacheLoader;
import net.savignano.snotify.atlassian.common.security.access.smime.SmimeCacheLoader;
import net.savignano.snotify.atlassian.common.user.AtlassianUser;
import net.savignano.snotify.atlassian.common.user.IUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IncomingMailCreateUserListener {
    private static final Logger log = LoggerFactory.getLogger(IncomingMailCreateUserListener.class);
    @Autowired
    @ComponentImport
    private EventPublisher publisher;
    @Autowired
    @ComponentImport
    private CacheManager cacheManager;
    @Autowired
    @ComponentImport
    private JiraThreadLocalUtil threadUtil;
    @Autowired
    private ISnotifyAppProperties appProperties;
    @Autowired
    private ISnotifyUserProperties userProperties;

    @PostConstruct
    public void init() {
        log.debug("Initializing S/Notify 'Receiving Mail Create User' Listener.");
        this.publisher.register((Object)this);
    }

    @PreDestroy
    public void destroy() {
        log.debug("Destroying S/Notify 'Receiving Mail Create User' Listener.");
        this.publisher.unregister((Object)this);
    }

    @EventListener
    public void userCreatedEvent(UserCreatedEvent userEvent) {
        if (this.appProperties.getBoolean(EProperty.LITE_MODE)) {
            return;
        }
        AtlassianUser user = new AtlassianUser(userEvent.getUser());
        this.check(user);
    }

    private void check(IUser<?> user) {
        log.debug("Checking if an S/MIME certificate or PGP key has been already received for: {}", (Object)user.getDisplayName());
        this.checkSmimeCert(user);
        this.checkPgpKey(user);
    }

    private void checkSmimeCert(IUser<?> user) {
        Cache cache = this.cacheManager.getCache("net.savignano.snotify.jira.cache.pgp.incomingMail");
        SmimeCacheLoader loader = new SmimeCacheLoader((Cache<String, X509Certificate>)cache);
        SmimeEncryptionKey key = (SmimeEncryptionKey)loader.loadKey(user.getEmail());
        if (key.isValid()) {
            log.info("Found S/MIME certificate for email <{}> in cache. Storing it to new user: {}", (Object)user.getEmail(), (Object)user.getDisplayName());
            try {
                this.userProperties.setBytes(EProperty.EMAIL_SMIME_CERT, key.getEncoded(), user);
                this.userProperties.setLong(EProperty.EMAIL_SMIME_TIME_STAMP, System.currentTimeMillis(), user);
                this.userProperties.setEnum(EProperty.EMAIL_SMIME_KEY_SOURCE, EKeySource.EMAIL, user);
            }
            catch (IOException e) {
                log.error("Could not store S/MIME certificate for user " + String.valueOf(user) + ". Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        if (key.getKeyValidity() != EKeyValidity.NOT_FOUND) {
            loader.clear(user.getEmail());
        }
    }

    private void checkPgpKey(IUser<?> user) {
        Cache cache = this.cacheManager.getCache("net.savignano.snotify.jira.cache.smime.incomingMail");
        PgpCacheLoader loader = new PgpCacheLoader((Cache<String, byte[]>)cache);
        PgpEncryptionKey key = (PgpEncryptionKey)loader.loadKey(user.getEmail());
        if (key.isValid()) {
            log.info("Found PGP key for email <{}> in cache. Storing it to new user: {}", (Object)user.getEmail(), (Object)user.getDisplayName());
            try {
                this.userProperties.setBytes(EProperty.EMAIL_PGP_KEY, key.getEncoded(), user);
                this.userProperties.setLong(EProperty.EMAIL_PGP_KEY_ID, key.getKey().getKeyID(), user);
                this.userProperties.setLong(EProperty.EMAIL_PGP_TIME_STAMP, System.currentTimeMillis(), user);
                this.userProperties.setEnum(EProperty.EMAIL_PGP_KEY_SOURCE, EKeySource.EMAIL, user);
            }
            catch (IOException e) {
                log.error("Could not store PGP public key for user " + String.valueOf(user) + ". Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        if (key.getKeyValidity() != EKeyValidity.NOT_FOUND) {
            loader.clear(user.getEmail());
        }
    }
}

