/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.gui.condition;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.enums.EEncryptionTypePriority;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import org.springframework.beans.factory.annotation.Autowired;

public class JsdEmailSettingsLinkCondition
implements Condition {
    @Autowired
    private ISnotifyAppProperties appProps;

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        if (this.appProps.getBoolean(EProperty.LITE_MODE)) {
            return true;
        }
        switch (this.appProps.getEnum(EProperty.ENCRYPTION_TYPE_PRIORITY, EEncryptionTypePriority.class)) {
            case PGP_ONLY: {
                return this.appProps.getBoolean(EProperty.ALLOW_JSD_PGP_PUBLIC_KEY_OVERWRITE);
            }
            case PGP_PREFERRED: 
            case SMIME_PREFERRED: {
                return this.appProps.getBoolean(EProperty.ALLOW_JSD_PGP_PUBLIC_KEY_OVERWRITE) || this.appProps.getBoolean(EProperty.ALLOW_JSD_SMIME_CERTIFICATE_OVERWRITE);
            }
            case SMIME_ONLY: {
                return this.appProps.getBoolean(EProperty.ALLOW_JSD_SMIME_CERTIFICATE_OVERWRITE);
            }
        }
        return false;
    }
}

