/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.gui.key.info;

import net.savignano.snotify.atlassian.gui.key.info.IKeyValueStyle;
import org.apache.commons.text.StringEscapeUtils;

public class HtmlKeyValueStyle
implements IKeyValueStyle {
    @Override
    public String build(String label, Object value, String id) {
        StringBuilder builder = new StringBuilder(150);
        builder.append("<dl>");
        this.buildLabel(label, id, builder);
        this.buildValue(value, id, builder);
        builder.append("</dl>\n");
        return builder.toString();
    }

    private void buildLabel(String label, String id, StringBuilder builder) {
        if (id == null) {
            builder.append("<dt>");
        } else {
            builder.append("<dt id=\"");
            builder.append(StringEscapeUtils.escapeHtml4((String)id));
            builder.append("-key\">");
        }
        builder.append(StringEscapeUtils.escapeHtml4((String)label));
        builder.append(":</dt>");
    }

    private void buildValue(Object value, String id, StringBuilder builder) {
        if (id == null) {
            builder.append("<dd>");
        } else {
            builder.append("<dd id=\"");
            builder.append(StringEscapeUtils.escapeHtml4((String)id));
            builder.append("-value\">");
        }
        if (value == null) {
            builder.append("N/A");
        } else {
            builder.append(StringEscapeUtils.escapeHtml4((String)value.toString()));
        }
        builder.append("</dd>");
    }
}

