/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.gui.key.info;

import net.savignano.snotify.atlassian.gui.key.info.IKeyValueStyle;
import org.apache.commons.text.StringEscapeUtils;

public class JsdHtmlKeyValueStyle
implements IKeyValueStyle {
    @Override
    public String build(String key, Object value, String id) {
        StringBuilder builder = new StringBuilder(150);
        builder.append("<tr>");
        this.buildLabel(key, id, builder);
        this.buildValue(value, id, builder);
        builder.append("</tr>\n");
        return builder.toString();
    }

    private void buildLabel(String key, String id, StringBuilder builder) {
        builder.append("<th align=\"right\" valign=\"top\" style=\"white-space:nowrap;\"");
        if (id != null) {
            builder.append(" id=\"");
            builder.append(StringEscapeUtils.escapeHtml4((String)id));
            builder.append("-key\"");
        }
        builder.append(">");
        builder.append(StringEscapeUtils.escapeHtml4((String)key));
        builder.append(":</th>");
    }

    private void buildValue(Object value, String id, StringBuilder builder) {
        builder.append("<td valign=\"top\"");
        if (id != null) {
            builder.append(" id=\"");
            builder.append(StringEscapeUtils.escapeHtml4((String)id));
            builder.append("-value\"");
        }
        builder.append(">");
        if (value == null) {
            builder.append("n/a");
        } else {
            builder.append(StringEscapeUtils.escapeHtml4((String)value.toString()));
        }
        builder.append("</td>");
    }
}

