/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.gui.rest.profile;

import com.atlassian.plugins.rest.api.security.annotation.UnlicensedSiteAccess;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.user.IUser;
import net.savignano.snotify.jira.common.JiraUser;
import net.savignano.snotify.jira.gui.rest.profile.PublicUserEditing;

@Path(value="deletePgpKey")
public class PublicPgpKeyDelete
extends PublicUserEditing {
    @DELETE
    @UnlicensedSiteAccess
    public Response delete(@QueryParam(value="atl_token") String token, @Context HttpServletRequest req) {
        JiraUser user = null;
        try {
            if (!this.getAuthContext().isLoggedInUser()) {
                this.getLog().info("PGP key deletion not authorized.");
                return this.createResponse(Response.Status.UNAUTHORIZED);
            }
            user = new JiraUser(this.getAuthContext().getLoggedInUser());
            if (!this.hasMatchinXsrfToken(token, req.getSession(false))) {
                this.getLog().warn("XSRF token violation detected when deleting a PGP keys for customer: {}", (Object)user);
                String msg = this.getI18n().getText("jsd-portal-email-security.error.xsrf.message");
                return this.createResponse(Response.Status.FORBIDDEN, msg);
            }
            if (!this.isUploadAllowed(ECryptographyType.PGP)) {
                this.getLog().info("Deleting of PGP keys is not allowed for user: {}", (Object)user);
                String msg = this.getI18n().getText("jsd-portal-email-security.error.pgp.delete.message.adminForbidden");
                return this.createResponse(Response.Status.FORBIDDEN, msg);
            }
            return this.deletePgpKey(user);
        }
        catch (Exception e) {
            this.getLog().error("Error while deleting PGP key for user " + String.valueOf(user) + ". Error message: " + e.getMessage(), (Throwable)e);
            String msg = this.getI18n().getText("jsd-portal-email-security.error.pgp.delete.message.generalException");
            return this.createResponse(Response.Status.INTERNAL_SERVER_ERROR, msg);
        }
    }

    private Response deletePgpKey(IUser<?> user) {
        this.getLog().info("Clearing PGP key for user: {}", (Object)user.getDisplayName());
        this.getUserProps().setLong(EProperty.EMAIL_PGP_KEY_ID, null, user);
        this.getUserProps().setBytes(EProperty.EMAIL_PGP_KEY, null, user);
        this.getUserProps().setLong(EProperty.EMAIL_PGP_TIME_STAMP, null, user);
        this.getUserProps().setEnum(EProperty.EMAIL_PGP_KEY_SOURCE, null, user);
        return this.createResponse(Response.Status.OK);
    }
}

