/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.gui.rest.profile;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import jakarta.servlet.http.HttpSession;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.properties.ISnotifyUserProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PublicUserEditing {
    private static final String XSRF_TOKEN_SESSION_KEY = "atlassian.xsrf.token";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private JiraAuthenticationContext context;
    @Autowired
    private ISnotifyAppProperties appProps;
    @Autowired
    private ISnotifyUserProperties userProps;
    private I18nHelper i18n;

    protected boolean isUploadAllowed(ECryptographyType type) {
        if (type == null) {
            return false;
        }
        switch (type) {
            case PGP: {
                return this.getAppProps().getBoolean(EProperty.ALLOW_JSD_PGP_PUBLIC_KEY_OVERWRITE) || this.getAppProps().getBoolean(EProperty.LITE_MODE);
            }
            case SMIME: {
                return this.getAppProps().getBoolean(EProperty.ALLOW_JSD_SMIME_CERTIFICATE_OVERWRITE) || this.getAppProps().getBoolean(EProperty.LITE_MODE);
            }
        }
        return false;
    }

    protected Response createResponse(Response.Status status) {
        return this.createResponse(status, null);
    }

    protected Response createResponse(Response.Status status, Object entity) {
        Response.ResponseBuilder builder = Response.status((Response.Status)status);
        if (entity != null) {
            builder.language(this.getAuthContext().getLocale()).entity(entity);
        }
        return builder.build();
    }

    protected boolean hasMatchinXsrfToken(String token, HttpSession session) {
        return session != null && Objects.equals(token, session.getAttribute(XSRF_TOKEN_SESSION_KEY));
    }

    protected JiraAuthenticationContext getAuthContext() {
        return this.context;
    }

    protected ISnotifyAppProperties getAppProps() {
        return this.appProps;
    }

    protected ISnotifyUserProperties getUserProps() {
        return this.userProps;
    }

    protected Logger getLog() {
        return this.log;
    }

    protected I18nHelper getI18n() {
        if (this.i18n == null) {
            this.i18n = ComponentAccessor.getI18nHelperFactory().getInstance(this.getAuthContext().getLocale());
        }
        return this.i18n;
    }
}

