/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.gui.webpanel;

import com.atlassian.jira.project.Project;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import java.util.HashMap;
import java.util.Map;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.properties.ISnotifyProjectProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ProjectSummaryContextProvider
implements ContextProvider {
    private static final String EDIT_ALLOWED_CONTEXT = "edit_allowed";
    private static final String ENCRYPTION_ENABLED_CONTEXT = "encryption_enabled";
    private static final String GUI_PLUGIN_KEY_CONTEXT = "gui_plugin_key";
    private static final String CURRENT_PROJECT_CONTEXT = "atl.jira.admin.current.project";
    private static final Logger log = LoggerFactory.getLogger(ProjectSummaryContextProvider.class);
    @Autowired
    private ISnotifyAppProperties appProps;
    @Autowired
    private ISnotifyProjectProperties projectProps;

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>(context);
        contextMap.put(GUI_PLUGIN_KEY_CONTEXT, this.getGuiPluginKey());
        contextMap.put(EDIT_ALLOWED_CONTEXT, this.isEditAllowed());
        contextMap.put(ENCRYPTION_ENABLED_CONTEXT, this.isEncryptionEnabled((Project)context.get(CURRENT_PROJECT_CONTEXT)));
        return contextMap;
    }

    private String getGuiPluginKey() {
        return this.appProps.getString(EProperty.GUI_KEY);
    }

    private boolean isEditAllowed() {
        boolean allowed = this.appProps.getBoolean(EProperty.ENABLE_PROJECT_SPECIFIC_ENCRYPTION);
        log.debug("Project specific encryption enabled: {}", (Object)allowed);
        return allowed;
    }

    private boolean isEncryptionEnabled(Project project) {
        if (this.appProps.getBoolean(EProperty.ENABLE_PROJECT_SPECIFIC_ENCRYPTION)) {
            if (project == null) {
                log.error("No project given. Can't determine status of encryption.");
                return false;
            }
            String projectKey = project.getKey();
            boolean defEnc = this.appProps.getBoolean(EProperty.DEFAULT_PROJECT_ENCRYPTION_STATE);
            boolean enabled = this.projectProps.getBoolean(EProperty.PROJECT_ENABLE_ENCRYPTION, defEnc, projectKey);
            log.debug("Encryption enabled for project {}: {}", (Object)projectKey, (Object)enabled);
            return enabled;
        }
        return true;
    }
}

