/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.gui.webwork;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.InvalidKeyException;
import java.security.KeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyPurpose;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.cryptography.util.SmimeUtil;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.enums.EEncryptionTypePriority;
import net.savignano.snotify.atlassian.common.properties.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.gui.key.info.PgpPublicKeyInfoBuilder;
import net.savignano.snotify.atlassian.gui.key.info.SmimeCertInfoBuilder;
import net.savignano.snotify.jira.common.JiraUser;
import net.savignano.snotify.jira.common.SnotifyI18n;
import net.savignano.snotify.jira.common.SnotifyUserProperties;
import net.savignano.snotify.jira.gui.key.info.HtmlKeyValueStyle;
import net.savignano.snotify.jira.gui.webwork.SnotifyWebAction;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import webwork.action.ServletActionContext;
import webwork.multipart.MultiPartRequestWrapper;

public class EmailSecurityEditWebworkAction
extends SnotifyWebAction {
    private static final long serialVersionUID = 290039522220220096L;
    private static final String REDIRECT_USER_PROFILE = "ViewProfile.jspa";
    private static final String REDIRECT_NOT_LOGGED_IN = "login.jsp?permissionViolation=true&os_destination=%2Fsecure%2FViewProfile.jspa&page_caps=&user_role=";
    private static final String DELETE_BUTTON_PARAM = "Delete";
    private static final String FILE_PARAM = "file";
    private final ISnotifyUserProperties userProps = new SnotifyUserProperties();
    private String errorMessage;
    private EEncryptionTypePriority typePriority;
    private ECryptographyType lastUpload;
    private Boolean allowSmimeUpload;
    private Boolean allowPgpUpload;

    @SupportedMethods(value={RequestMethod.GET})
    public String doInput() {
        ApplicationUser user = this.getLoggedInUser();
        if (user == null) {
            this.getRedirect(REDIRECT_NOT_LOGGED_IN);
            return null;
        }
        this.lastUpload = null;
        return "input";
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doSubmitSmime() {
        File certFile;
        this.errorMessage = null;
        if (!"POST".equals(this.getHttpRequest().getMethod())) {
            this.getLog().debug("Access to submit method redirected to input method, as request method wasn't 'POST'. Used method: " + this.getHttpRequest().getMethod());
            return this.doInput();
        }
        ApplicationUser appUser = this.getLoggedInUser();
        if (appUser == null) {
            this.getRedirect(REDIRECT_NOT_LOGGED_IN);
            return null;
        }
        I18nHelper i18n = ComponentAccessor.getI18nHelperFactory().getInstance(appUser);
        JiraUser user = new JiraUser(appUser);
        if (!this.isAllowSmimeUpload()) {
            this.errorMessage = i18n.getText("email-security-edit-webwork.error-notallowed.smime.message");
            this.getLog().warn("Uploading of custom S/MIME certificate is not allowed. User: {}", (Object)user);
            return "input";
        }
        this.lastUpload = ECryptographyType.SMIME;
        MultiPartRequestWrapper requestWrapper = ServletActionContext.getMultiPartRequest();
        if (requestWrapper.getParameterMap().containsKey(DELETE_BUTTON_PARAM)) {
            certFile = null;
        } else {
            certFile = requestWrapper.getFile(FILE_PARAM);
            if (certFile == null) {
                this.errorMessage = i18n.getText("email-security-edit-webwork.error-nofile.message");
                this.getLog().info("No file selected to upload.");
                return "input";
            }
        }
        try {
            byte[] cert = certFile != null ? Files.readAllBytes(certFile.toPath()) : null;
            this.setEmailCert(cert, user);
            this.getRedirect(REDIRECT_USER_PROFILE);
        }
        catch (EmailException e) {
            this.errorMessage = i18n.getText("email-security-edit-webwork.error-email.message", StringEscapeUtils.escapeHtml4((String)StringUtils.join((Object[])e.getCertificateEmails(), (String)", ")), e.getUserAddress());
            this.getLog().info("Email address mismatch.", (Throwable)e);
            return "input";
        }
        catch (KeyException e) {
            this.errorMessage = i18n.getText("email-security-edit-webwork.error-encryption.message");
            this.getLog().info("Certificate not useable for encryption.", (Throwable)e);
            return "input";
        }
        catch (CertificateExpiredException e) {
            this.errorMessage = i18n.getText("email-security-edit-webwork.error-expired.message");
            this.getLog().info("Certificate expired.", (Throwable)e);
            return "input";
        }
        catch (CertificateNotYetValidException e) {
            this.errorMessage = i18n.getText("email-security-edit-webwork.error-notyetvalid.message");
            this.getLog().info("Certificate not yet valid.", (Throwable)e);
            return "input";
        }
        catch (IOException | CertificateException e) {
            this.errorMessage = i18n.getText("email-security-edit-webwork.error-smime.message", StringEscapeUtils.escapeHtml4((String)e.getMessage()));
            this.getLog().info("Certificate parsing failed.", (Throwable)e);
            return "input";
        }
        return null;
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doSubmitPgp() {
        File keyFile;
        this.errorMessage = null;
        if (!"POST".equals(this.getHttpRequest().getMethod())) {
            this.getLog().debug("Access to submit method redirected to input method, as request method wasn't 'POST'. Used method: " + this.getHttpRequest().getMethod());
            return this.doInput();
        }
        ApplicationUser appUser = this.getLoggedInUser();
        if (appUser == null) {
            this.getRedirect(REDIRECT_NOT_LOGGED_IN);
            return null;
        }
        I18nHelper i18n = ComponentAccessor.getI18nHelperFactory().getInstance(appUser);
        JiraUser user = new JiraUser(appUser);
        if (!this.isAllowPgpUpload()) {
            this.errorMessage = i18n.getText("email-security-edit-webwork.error-notallowed.pgp.message");
            this.getLog().warn("Uploading of custom PGP key is not allowed. User: {}", (Object)user);
            return "input";
        }
        this.lastUpload = ECryptographyType.PGP;
        MultiPartRequestWrapper requestWrapper = ServletActionContext.getMultiPartRequest();
        if (requestWrapper.getParameterMap().containsKey(DELETE_BUTTON_PARAM)) {
            keyFile = null;
        } else {
            keyFile = requestWrapper.getFile(FILE_PARAM);
            if (keyFile == null) {
                this.errorMessage = i18n.getText("email-security-edit-webwork.error-nofile.message");
                this.getLog().info("No file selected to upload.");
                return "input";
            }
        }
        try {
            byte[] key = keyFile != null ? Files.readAllBytes(keyFile.toPath()) : null;
            this.setEmailPgpKey(key, user);
            this.getRedirect(REDIRECT_USER_PROFILE);
        }
        catch (IOException | PGPException e) {
            this.errorMessage = i18n.getText("email-security-edit-webwork.error-pgp.message", StringEscapeUtils.escapeHtml4((String)e.getMessage()));
            this.getLog().info("Key parsing failed. Error message: " + e.getMessage(), (Throwable)e);
            return "input";
        }
        catch (KeyException e) {
            StringBuilder builder = new StringBuilder(500);
            builder.append("<p>");
            builder.append(i18n.getText("email-security-edit-webwork.error-keynotfound.message.pre"));
            builder.append("<p><ul>");
            builder.append("<li>");
            builder.append(i18n.getText("email-security-edit-webwork.error-keynotfound.message.list.email"));
            builder.append("</li><li>");
            builder.append(i18n.getText("email-security-edit-webwork.error-keynotfound.message.list.valid"));
            builder.append("</li><li>");
            builder.append(i18n.getText("email-security-edit-webwork.error-keynotfound.message.list.encryption"));
            builder.append("</li><li>");
            builder.append(i18n.getText("email-security-edit-webwork.error-keynotfound.message.list.revoked"));
            builder.append("</li>");
            builder.append("</ul><p>");
            builder.append(i18n.getText("email-security-edit-webwork.error-keynotfound.message.post"));
            builder.append("</p>");
            this.errorMessage = builder.toString();
            this.getLog().info("No valid key found. Error message: " + e.getMessage(), (Throwable)e);
            return "input";
        }
        return null;
    }

    private void setEmailCert(byte[] cert, JiraUser user) throws CertificateException, KeyException {
        if (cert == null || cert.length == 0) {
            this.getLog().info("Clearing S/MIME certificate for user: {}", (Object)user.getDisplayName());
            this.userProps.setBytes(EProperty.EMAIL_SMIME_CERT, null, user);
            this.userProps.setLong(EProperty.EMAIL_SMIME_TIME_STAMP, null, user);
            this.userProps.setEnum(EProperty.EMAIL_SMIME_KEY_SOURCE, null, user);
        } else {
            this.getLog().debug("Checking certificate for user: " + user.getDisplayName());
            this.checkSmimeCert(cert, user);
            this.getLog().info("Setting S/MIME certificate for user: {}", (Object)user.getDisplayName());
            this.userProps.setBytes(EProperty.EMAIL_SMIME_CERT, cert, user);
            this.userProps.setLong(EProperty.EMAIL_SMIME_TIME_STAMP, System.currentTimeMillis(), user);
            this.userProps.setEnum(EProperty.EMAIL_SMIME_KEY_SOURCE, EKeySource.USER, user);
        }
    }

    private void checkSmimeCert(byte[] cert, JiraUser user) throws CertificateException, KeyException {
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)fact.generateCertificate(new ByteArrayInputStream(cert));
        certificate.checkValidity();
        if (!SmimeUtil.isCertForEmail(certificate, user.getEmail())) {
            throw new EmailException(SmimeUtil.getEmails(certificate), user.getEmail());
        }
        if (!SmimeUtil.isCertForPurpose(certificate, EKeyPurpose.ENCRYPTION)) {
            throw new InvalidKeyException("Certificate is not useable for encryption.");
        }
    }

    private void setEmailPgpKey(byte[] key, JiraUser user) throws IOException, PGPException, KeyException {
        if (key == null || key.length == 0) {
            this.getLog().info("Clearing PGP key for user: {}", (Object)user.getDisplayName());
            this.userProps.setLong(EProperty.EMAIL_PGP_KEY_ID, null, user);
            this.userProps.setBytes(EProperty.EMAIL_PGP_KEY, null, user);
            this.userProps.setLong(EProperty.EMAIL_PGP_TIME_STAMP, null, user);
            this.userProps.setEnum(EProperty.EMAIL_PGP_KEY_SOURCE, null, user);
        } else {
            this.getLog().debug("Checking PGP key for user: {}", (Object)user.getDisplayName());
            String userEmailAddress = user.getEmail().toLowerCase();
            PGPPublicKeyRingCollection keyRings = PgpUtil.loadPublicKeys(new ByteArrayInputStream(key));
            PGPPublicKeyRing keyRing = PgpUtil.getKeysForEmail(keyRings, userEmailAddress);
            if (keyRing == null) {
                throw new KeyException("Could not find a key ring for email address: " + userEmailAddress);
            }
            PgpEncryptionKey usedKey = new PgpEncryptionKey(keyRing, userEmailAddress);
            PGPPublicKey encKey = usedKey.getKey();
            if (encKey == null) {
                throw new KeyException("Could not find a valid encryption key.");
            }
            this.getLog().info("Setting PGP key for user: {}", (Object)user.getDisplayName());
            this.userProps.setBytes(EProperty.EMAIL_PGP_KEY, key, user);
            this.userProps.setLong(EProperty.EMAIL_PGP_KEY_ID, encKey.getKeyID(), user);
            this.userProps.setLong(EProperty.EMAIL_PGP_TIME_STAMP, System.currentTimeMillis(), user);
            this.userProps.setEnum(EProperty.EMAIL_PGP_KEY_SOURCE, EKeySource.USER, user);
        }
    }

    @HtmlSafe
    public String getCertDetails() {
        JiraUser user = new JiraUser(this.getLoggedInUser());
        SnotifyI18n i18n = new SnotifyI18n(ComponentAccessor.getI18nHelperFactory().getInstance(user.getActualUser()));
        String displayName = user.getDisplayName();
        Object cert = this.getAppProps().getBoolean(EProperty.LITE_MODE) && this.userProps.getEnum(EProperty.EMAIL_SMIME_KEY_SOURCE, EKeySource.class, user) != EKeySource.USER ? null : this.userProps.getBytes(EProperty.EMAIL_SMIME_CERT, user);
        String certInfo = null;
        if (cert == null) {
            certInfo = i18n.getText("email-security-edit-webwork.input.smime.notfound");
            this.getLog().debug("No S/MIME certificate specified for user: {}", (Object)displayName);
        } else {
            try {
                SmimeCertInfoBuilder builder = new SmimeCertInfoBuilder((byte[])cert, (ISnotifyI18n)i18n);
                builder.setUser(user);
                builder.setUserProps(this.userProps);
                certInfo = builder.build(new HtmlKeyValueStyle());
                this.getLog().debug("Certificate information for user {}: {}", (Object)displayName, (Object)certInfo);
            }
            catch (CertificateException e) {
                this.getLog().error("Could not load S/MIME certificate for user: " + displayName, (Throwable)e);
                certInfo = i18n.getText("email-security-edit-webwork.input.smime.error", (Object)e.getLocalizedMessage());
            }
        }
        return certInfo;
    }

    @HtmlSafe
    public String getPgpDetails() {
        Long keyId;
        byte[] key;
        JiraUser user = new JiraUser(this.getLoggedInUser());
        SnotifyI18n i18n = new SnotifyI18n(ComponentAccessor.getI18nHelperFactory().getInstance(user.getActualUser()));
        String displayName = user.getDisplayName();
        if (this.getAppProps().getBoolean(EProperty.LITE_MODE) && this.userProps.getEnum(EProperty.EMAIL_PGP_KEY_SOURCE, EKeySource.class, user) != EKeySource.USER) {
            key = null;
            keyId = null;
        } else {
            key = this.userProps.getBytes(EProperty.EMAIL_PGP_KEY, user);
            keyId = this.userProps.getLong(EProperty.EMAIL_PGP_KEY_ID, user);
        }
        String keyInfo = null;
        if (keyId == null || key == null) {
            keyInfo = i18n.getText("email-security-edit-webwork.input.pgp.notfound");
            this.getLog().debug("No PGP key specified for user: {}", (Object)displayName);
        } else {
            try {
                PgpPublicKeyInfoBuilder builder = new PgpPublicKeyInfoBuilder(key, (long)keyId, (ISnotifyI18n)i18n);
                builder.setUser(user);
                builder.setUserProps(this.userProps);
                keyInfo = builder.build(new HtmlKeyValueStyle());
                this.getLog().debug("Key information for user {}: {}", (Object)displayName, (Object)keyInfo);
            }
            catch (IOException | PGPException e) {
                this.getLog().error("Could not load PGP key for user: " + displayName, (Throwable)e);
                keyInfo = i18n.getText("email-security-edit-webwork.input.pgp.error", (Object)e.getLocalizedMessage());
            }
        }
        return keyInfo;
    }

    public boolean isChoiceEnabled() {
        switch (this.getTypePriority()) {
            case SMIME_PREFERRED: 
            case PGP_PREFERRED: {
                return this.isAllowPgpUpload() && this.isAllowSmimeUpload();
            }
            case SMIME_ONLY: 
            case PGP_ONLY: {
                return false;
            }
        }
        this.getLog().warn("Unknwon value for 'Encryption Type Priority' found. Value found was '" + String.valueOf((Object)this.getTypePriority()) + "'. It is not yet implemented,");
        return true;
    }

    public boolean isSmimeSelected() {
        if (this.lastUpload == ECryptographyType.SMIME) {
            return true;
        }
        if (this.lastUpload == ECryptographyType.PGP) {
            return false;
        }
        switch (this.getTypePriority()) {
            case SMIME_ONLY: {
                return true;
            }
            case PGP_ONLY: {
                return false;
            }
            case SMIME_PREFERRED: {
                return this.isAllowSmimeUpload() || !this.isAllowPgpUpload();
            }
            case PGP_PREFERRED: {
                return this.isAllowSmimeUpload() && !this.isAllowPgpUpload();
            }
        }
        this.getLog().warn("Unknwon value for 'Encryption Type Priority' found. Value found was '" + String.valueOf((Object)this.getTypePriority()) + "'. It is not yet implemented,");
        return true;
    }

    public boolean isPgpSelected() {
        if (this.lastUpload == ECryptographyType.PGP) {
            return true;
        }
        if (this.lastUpload == ECryptographyType.SMIME) {
            return false;
        }
        switch (this.getTypePriority()) {
            case SMIME_ONLY: {
                return false;
            }
            case PGP_ONLY: {
                return true;
            }
            case SMIME_PREFERRED: {
                return this.isAllowPgpUpload() && !this.isAllowSmimeUpload();
            }
            case PGP_PREFERRED: {
                return this.isAllowPgpUpload() || !this.isAllowSmimeUpload();
            }
        }
        this.getLog().warn("Unknwon value for 'Encryption Type Priority' found. Value found was '" + String.valueOf((Object)this.getTypePriority()) + "'. It is not yet implemented,");
        return false;
    }

    public boolean isSmimeUploadAllowed() {
        return this.isAllowSmimeUpload();
    }

    public boolean isPgpUploadAllowed() {
        return this.isAllowPgpUpload();
    }

    public boolean isShowError() {
        return this.errorMessage != null;
    }

    @HtmlSafe
    public String getErrorMessage() {
        return this.errorMessage == null ? "" : this.errorMessage;
    }

    private EEncryptionTypePriority getTypePriority() {
        if (this.typePriority == null) {
            this.typePriority = this.getAppProps().getEnum(EProperty.ENCRYPTION_TYPE_PRIORITY, EEncryptionTypePriority.class);
        }
        return this.typePriority;
    }

    private boolean isAllowSmimeUpload() {
        if (this.allowSmimeUpload == null) {
            this.allowSmimeUpload = this.getAppProps().getBoolean(EProperty.ALLOW_SMIME_CERTIFICATE_OVERWRITE) || this.getAppProps().getBoolean(EProperty.LITE_MODE);
        }
        return this.allowSmimeUpload;
    }

    private boolean isAllowPgpUpload() {
        if (this.allowPgpUpload == null) {
            this.allowPgpUpload = this.getAppProps().getBoolean(EProperty.ALLOW_PGP_PUBLIC_KEY_OVERWRITE) || this.getAppProps().getBoolean(EProperty.LITE_MODE);
        }
        return this.allowPgpUpload;
    }

    private static final class EmailException
    extends CertificateException {
        private static final long serialVersionUID = -5610482481952335343L;
        private final String[] emails;
        private final String userAddress;

        private EmailException(String[] emails, String userAddress) {
            super("Email address(es) of certificate " + Arrays.toString(emails) + " does not match user email address (" + userAddress + ")");
            this.emails = emails;
            this.userAddress = userAddress;
        }

        public String[] getCertificateEmails() {
            return this.emails;
        }

        public String getUserAddress() {
            return this.userAddress;
        }
    }
}

