/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.mail.smime.examples;

import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Properties;
import net.savignano.thirdparty.org.bouncycastle.cms.RecipientInformation;
import net.savignano.thirdparty.org.bouncycastle.cms.RecipientInformationStore;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.JceKeyTransRecipientId;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEEnvelopedParser;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEUtil;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.examples.ExampleUtils;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.util.FileBackedMimeBodyPart;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.util.SharedFileInputStream;

public class ReadLargeEncryptedMail {
    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.err.println("usage: ReadLargeEncryptedMail pkcs12Keystore password outputFile");
            System.exit(0);
        }
        KeyStore ks = KeyStore.getInstance("PKCS12", "SAVIGNANO-BC");
        String keyAlias = ExampleUtils.findKeyAlias(ks, args[0], args[1].toCharArray());
        X509Certificate cert = (X509Certificate)ks.getCertificate(keyAlias);
        JceKeyTransRecipientId recId = new JceKeyTransRecipientId(cert);
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(session, (InputStream)new SharedFileInputStream("encrypted.message"));
        SMIMEEnvelopedParser m = new SMIMEEnvelopedParser(msg);
        RecipientInformationStore recipients = m.getRecipientInfos();
        RecipientInformation recipient = recipients.get(recId);
        FileBackedMimeBodyPart res = SMIMEUtil.toMimeBodyPart(recipient.getContentStream(new JceKeyTransEnvelopedRecipient((PrivateKey)ks.getKey(keyAlias, null)).setProvider("SAVIGNANO-BC")));
        ExampleUtils.dumpContent(res, args[2]);
    }
}

