/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGOutputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.OnePassSignaturePacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.Packet;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPDefaultSignatureGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignature;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPContentVerifier;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;

public class PGPOnePassSignature
extends PGPDefaultSignatureGenerator {
    private OnePassSignaturePacket sigPack;
    private PGPContentVerifier verifier;

    private static OnePassSignaturePacket cast(Packet packet) throws IOException {
        if (!(packet instanceof OnePassSignaturePacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        return (OnePassSignaturePacket)packet;
    }

    public PGPOnePassSignature(BCPGInputStream pIn) throws IOException, PGPException {
        this(PGPOnePassSignature.cast(pIn.readPacket()));
    }

    PGPOnePassSignature(OnePassSignaturePacket sigPack) {
        this.sigPack = sigPack;
        this.sigType = sigPack.getSignatureType();
    }

    public void init(PGPContentVerifierBuilderProvider verifierBuilderProvider, PGPPublicKey pubKey) throws PGPException {
        PGPContentVerifierBuilder verifierBuilder = verifierBuilderProvider.get(this.sigPack.getKeyAlgorithm(), this.sigPack.getHashAlgorithm());
        this.verifier = verifierBuilder.build(pubKey);
        this.lastb = 0;
        this.sigOut = this.verifier.getOutputStream();
    }

    public boolean verify(PGPSignature pgpSig) throws PGPException {
        try {
            this.sigOut.write(pgpSig.getSignatureTrailer());
            this.sigOut.close();
        }
        catch (IOException e) {
            throw new PGPException("unable to add trailer: " + e.getMessage(), e);
        }
        return this.verifier.verify(pgpSig.getSignature());
    }

    public long getKeyID() {
        return this.sigPack.getKeyID();
    }

    public int getSignatureType() {
        return this.sigPack.getSignatureType();
    }

    public int getHashAlgorithm() {
        return this.sigPack.getHashAlgorithm();
    }

    public int getKeyAlgorithm() {
        return this.sigPack.getKeyAlgorithm();
    }

    public boolean isContaining() {
        return this.sigPack.isContaining();
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    public void encode(OutputStream outStream) throws IOException {
        BCPGOutputStream.wrap(outStream).writePacket(this.sigPack);
    }
}

