/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator;

import java.io.IOException;
import java.math.BigInteger;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPAlgorithmParameters;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPKdfParameters;
import net.savignano.thirdparty.org.bouncycastle.util.BigIntegers;

public abstract class PGPKeyConverter {
    protected PGPKeyConverter() {
    }

    protected PGPKdfParameters implGetKdfParameters(ASN1ObjectIdentifier curveID, PGPAlgorithmParameters algorithmParameters) {
        if (null == algorithmParameters) {
            if (curveID.equals(SECObjectIdentifiers.secp256r1) || curveID.equals(TeleTrusTObjectIdentifiers.brainpoolP256r1) || curveID.equals(CryptlibObjectIdentifiers.curvey25519) || curveID.equals(EdECObjectIdentifiers.id_X25519)) {
                return new PGPKdfParameters(8, 7);
            }
            if (curveID.equals(SECObjectIdentifiers.secp384r1) || curveID.equals(TeleTrusTObjectIdentifiers.brainpoolP384r1)) {
                return new PGPKdfParameters(9, 8);
            }
            if (curveID.equals(SECObjectIdentifiers.secp521r1) || curveID.equals(TeleTrusTObjectIdentifiers.brainpoolP512r1)) {
                return new PGPKdfParameters(10, 9);
            }
            throw new IllegalArgumentException("unknown curve");
        }
        return (PGPKdfParameters)algorithmParameters;
    }

    protected PrivateKeyInfo getPrivateKeyInfo(ASN1ObjectIdentifier algorithm, int keySize, byte[] key) throws IOException {
        return new PrivateKeyInfo(new AlgorithmIdentifier(algorithm), new DEROctetString(BigIntegers.asUnsignedByteArray(keySize, new BigInteger(1, key))));
    }

    protected PrivateKeyInfo getPrivateKeyInfo(ASN1ObjectIdentifier algorithm, byte[] key) throws IOException {
        return new PrivateKeyInfo(new AlgorithmIdentifier(algorithm), new DEROctetString(key));
    }
}

