/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.newhope;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.savignano.thirdparty.org.bouncycastle.crypto.KeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.Xof;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.SHAKEDigest;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ExchangePair;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.newhope.NHAgreement;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.newhope.NHExchangePairGenerator;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.newhope.NHKeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class NHSecretKeyProcessor {
    private final Xof xof = new SHAKEDigest(256);

    private NHSecretKeyProcessor(byte[] secret, byte[] shared) {
        this.xof.update(secret, 0, secret.length);
        if (shared != null) {
            this.xof.update(shared, 0, shared.length);
        }
        Arrays.fill(secret, (byte)0);
    }

    public byte[] processKey(byte[] initialKey) {
        byte[] xorBytes = new byte[initialKey.length];
        this.xof.doFinal(xorBytes, 0, xorBytes.length);
        NHSecretKeyProcessor.xor(initialKey, xorBytes);
        Arrays.fill(xorBytes, (byte)0);
        return initialKey;
    }

    private static void xor(byte[] a, byte[] b) {
        for (int i = 0; i != a.length; ++i) {
            int n = i;
            a[n] = (byte)(a[n] ^ b[i]);
        }
    }

    public static class PartyVBuilder {
        protected final SecureRandom random;
        private byte[] sharedInfo = null;
        private byte[] sharedSecret = null;
        private boolean used = false;

        public PartyVBuilder(SecureRandom random) {
            this.random = random;
        }

        public PartyVBuilder withSharedInfo(byte[] sharedInfo) {
            this.sharedInfo = Arrays.clone(sharedInfo);
            return this;
        }

        public byte[] getPartB(byte[] partUContribution) {
            NHExchangePairGenerator exchGen = new NHExchangePairGenerator(this.random);
            ExchangePair bEp = exchGen.generateExchange(new NHPublicKeyParameters(partUContribution));
            this.sharedSecret = bEp.getSharedValue();
            return ((NHPublicKeyParameters)bEp.getPublicKey()).getPubData();
        }

        public NHSecretKeyProcessor build() {
            if (this.used) {
                throw new IllegalStateException("builder already used");
            }
            this.used = true;
            return new NHSecretKeyProcessor(this.sharedSecret, this.sharedInfo);
        }
    }

    public static class PartyUBuilder {
        private final AsymmetricCipherKeyPair aKp;
        private final NHAgreement agreement = new NHAgreement();
        private byte[] sharedInfo = null;
        private boolean used = false;

        public PartyUBuilder(SecureRandom random) {
            NHKeyPairGenerator kpGen = new NHKeyPairGenerator();
            kpGen.init(new KeyGenerationParameters(random, 2048));
            this.aKp = kpGen.generateKeyPair();
            this.agreement.init(this.aKp.getPrivate());
        }

        public PartyUBuilder withSharedInfo(byte[] sharedInfo) {
            this.sharedInfo = Arrays.clone(sharedInfo);
            return this;
        }

        public byte[] getPartA() {
            return ((NHPublicKeyParameters)this.aKp.getPublic()).getPubData();
        }

        public NHSecretKeyProcessor build(byte[] partB) {
            if (this.used) {
                throw new IllegalStateException("builder already used");
            }
            this.used = true;
            return new NHSecretKeyProcessor(this.agreement.calculateAgreement(new NHPublicKeyParameters(partB)), this.sharedInfo);
        }
    }
}

