/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntruprime;

import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.KeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntruprime.NTRULPRimeKeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntruprime.NTRULPRimePrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntruprime.NTRULPRimePublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntruprime.Utils;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class NTRULPRimeKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private NTRULPRimeKeyGenerationParameters params;

    public NTRULPRimeKeyGenerationParameters getParams() {
        return this.params;
    }

    @Override
    public void init(KeyGenerationParameters param) {
        this.params = (NTRULPRimeKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        int p = this.params.getNtrulprParams().getP();
        int q = this.params.getNtrulprParams().getQ();
        int w = this.params.getNtrulprParams().getW();
        byte[] seed = new byte[32];
        this.params.getRandom().nextBytes(seed);
        short[] G = new short[p];
        Utils.generatePolynomialInRQFromSeed(G, seed, p, q);
        byte[] a = new byte[p];
        Utils.getRandomShortPolynomial(this.params.getRandom(), a, p, w);
        short[] aG = new short[p];
        Utils.multiplicationInRQ(aG, G, a, p, q);
        short[] A = new short[p];
        Utils.roundPolynomial(A, aG);
        byte[] roundEncA = new byte[this.params.getNtrulprParams().getPublicKeyBytes() - 32];
        Utils.getRoundedEncodedPolynomial(roundEncA, A, p, q);
        NTRULPRimePublicKeyParameters publicKey = new NTRULPRimePublicKeyParameters(this.params.getNtrulprParams(), seed, roundEncA);
        byte[] enca = new byte[(p + 3) / 4];
        Utils.getEncodedSmallPolynomial(enca, a, p);
        byte[] rho = new byte[32];
        this.params.getRandom().nextBytes(rho);
        byte[] prefix = new byte[]{4};
        byte[] hash = Utils.getHashWithPrefix(prefix, publicKey.getEncoded());
        NTRULPRimePrivateKeyParameters privateKey = new NTRULPRimePrivateKeyParameters(this.params.getNtrulprParams(), enca, publicKey.getEncoded(), rho, Arrays.copyOfRange(hash, 0, hash.length / 2));
        return new AsymmetricCipherKeyPair(publicKey, privateKey);
    }
}

